/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.column;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.datatable.column.IColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class AbstractColumn
implements IColumn {
    private static final long serialVersionUID = 1L;
    static final int WIDTH = -1;
    private final String field;
    private final IModel<String> title;
    private Integer width;

    public AbstractColumn(String title) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), "", -1);
    }

    public AbstractColumn(String title, int width) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), "", width);
    }

    public AbstractColumn(String title, String field) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), field, -1);
    }

    public AbstractColumn(String title, String field, int width) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), field, width);
    }

    public AbstractColumn(IModel<String> title) {
        this(title, "", -1);
    }

    public AbstractColumn(IModel<String> title, int width) {
        this(title, "", width);
    }

    public AbstractColumn(IModel<String> title, String field) {
        this(title, field, -1);
    }

    public AbstractColumn(IModel<String> title, String field, int width) {
        this.title = title;
        this.field = field;
        this.width = width;
    }

    @Override
    public String getTitle() {
        return (String)this.title.getObject();
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public boolean isVisible() {
        return true;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public String getTemplate() {
        return null;
    }

    @Override
    public String getFilterable() {
        return null;
    }

    @Override
    public String getMenu() {
        return null;
    }

    @Override
    public List<String> getAggregates() {
        return Collections.emptyList();
    }

    protected String getAggregatesAsString() {
        ArrayList<String> aggregates = new ArrayList<String>();
        for (String aggregate : this.getAggregates()) {
            aggregates.add(Options.asString((String)aggregate));
        }
        return ((Object)aggregates).toString();
    }

    @Override
    public String getGroupHeaderTemplate() {
        return null;
    }

    @Override
    public String getGroupFooterTemplate() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\"").append("title").append("\"").append(": ").append("\"").append(this.getTitle()).append("\"");
        builder.append(", ");
        builder.append("\"").append("field").append("\"").append(": ").append("\"").append(this.getField()).append("\"");
        builder.append(", ");
        builder.append("\"").append("hidden").append("\"").append(": ").append(!this.isVisible());
        if (this.getWidth() > 0) {
            builder.append(", ");
            builder.append("\"").append("width").append("\"").append(": ").append(this.getWidth());
        }
        if (this.getFormat() != null) {
            builder.append(", ");
            builder.append("\"").append("format").append("\"").append(": ").append("\"").append(this.getFormat()).append("\"");
        }
        if (this.getTemplate() != null) {
            builder.append(", ");
            builder.append("\"").append("template").append("\"").append(": ").append(this.getTemplate());
        }
        if (this.getGroupHeaderTemplate() != null) {
            builder.append(", ");
            builder.append("\"").append("groupHeaderTemplate").append("\"").append(": ").append("\"").append(this.getGroupHeaderTemplate()).append("\"");
        }
        if (this.getGroupFooterTemplate() != null) {
            builder.append(", ");
            builder.append("\"").append("groupFooterTemplate").append("\"").append(": ").append("\"").append(this.getGroupFooterTemplate()).append("\"");
        }
        if (this.getMenu() != null) {
            builder.append(", ");
            builder.append("\"").append("menu").append("\"").append(": ").append(this.getMenu());
        }
        if (!this.getAggregates().isEmpty()) {
            builder.append(", ");
            builder.append("\"").append("aggregates").append("\"").append(": ").append(this.getAggregatesAsString());
        }
        if (this.getFilterable() != null) {
            builder.append(", ");
            builder.append("\"").append("filterable").append("\"").append(": ").append(this.getFilterable());
        }
        return builder.toString();
    }
}

