/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.kendo.ui.KendoBehaviorFactory;
import com.googlecode.wicket.kendo.ui.datatable.ColumnAjaxBehavior;
import com.googlecode.wicket.kendo.ui.datatable.ColumnButton;
import com.googlecode.wicket.kendo.ui.datatable.DataSourceBehavior;
import com.googlecode.wicket.kendo.ui.datatable.DataTableBehavior;
import com.googlecode.wicket.kendo.ui.datatable.IDataTableListener;
import com.googlecode.wicket.kendo.ui.datatable.column.IColumn;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.repeater.data.IDataProvider;

public class DataTable<T>
extends WebComponent
implements IJQueryWidget,
IDataTableListener {
    private static final long serialVersionUID = 1L;
    private AbstractAjaxBehavior sourceBehavior;
    private final Options options;
    private final List<? extends IColumn> columns;
    private final IDataProvider<T> provider;
    private final long rows;

    public DataTable(String id, List<? extends IColumn> columns, IDataProvider<T> provider, long rows) {
        this(id, columns, provider, rows, new Options());
    }

    public DataTable(String id, List<? extends IColumn> columns, IDataProvider<T> provider, long rows, Options options) {
        super(id);
        this.columns = columns;
        this.provider = provider;
        this.options = options;
        this.rows = rows;
    }

    protected String widget() {
        return String.format("jQuery('%s').data('%s')", IJQueryWidget.JQueryWidget.getSelector((Component)this), "kendoGrid");
    }

    public final void show(AjaxRequestTarget target) {
        this.onShow(target);
        KendoBehaviorFactory.show(target, (Component)this);
    }

    public final void hide(AjaxRequestTarget target) {
        KendoBehaviorFactory.hide(target, (Component)this);
        this.onHide(target);
    }

    public void refresh(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("var grid = %s; grid.dataSource.read(); grid.refresh();", this.widget()));
    }

    public IDataProvider<T> getDataProvider() {
        return this.provider;
    }

    protected final long getRowCount() {
        return this.rows;
    }

    public final List<? extends IColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    protected Options getSchemaModel() {
        Options fields = new Options();
        for (IColumn column : this.getColumns()) {
            if (column.getType() == null) continue;
            fields.set(column.getField(), (Object)new Options("type", (Object)Options.asString((String)column.getType())));
        }
        return new Options("fields", (Object)fields);
    }

    protected final CharSequence getSourceCallbackUrl() {
        return this.sourceBehavior.getCallbackUrl();
    }

    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.sourceBehavior = this.newDataSourceBehavior(this.columns, this.provider);
        behaviorArray[0] = this.sourceBehavior;
        this.add(behaviorArray);
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("sortable", (Object)(this.provider instanceof ISortStateLocator));
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, "");
    }

    public void onShow(AjaxRequestTarget target) {
    }

    public void onHide(AjaxRequestTarget target) {
    }

    @Override
    public void onClick(AjaxRequestTarget target, ColumnButton button, String value) {
    }

    @Override
    public void onClick(AjaxRequestTarget target, String button, List<String> values) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new DataTableBehavior(selector, this.options, this.columns){
            private static final long serialVersionUID = 1L;

            @Override
            protected long getRowCount() {
                return DataTable.this.getRowCount();
            }

            @Override
            protected Options getSchemaModel() {
                return DataTable.this.getSchemaModel();
            }

            @Override
            protected CharSequence getSourceCallbackUrl() {
                return DataTable.this.getSourceCallbackUrl();
            }

            @Override
            public void onClick(AjaxRequestTarget target, ColumnButton button, String value) {
                DataTable.this.onClick(target, button, value);
            }

            @Override
            public void onClick(AjaxRequestTarget target, String button, List<String> values) {
                DataTable.this.onClick(target, button, values);
            }

            @Override
            protected JQueryAjaxBehavior newToolbarAjaxBehavior() {
                return DataTable.this.newToolbarAjaxBehavior(this);
            }

            @Override
            protected JQueryAjaxBehavior newButtonAjaxBehavior(ColumnButton button) {
                return DataTable.this.newColumnAjaxBehavior(this, button);
            }
        };
    }

    protected AbstractAjaxBehavior newDataSourceBehavior(List<? extends IColumn> columns, IDataProvider<T> provider) {
        return new DataSourceBehavior<T>(columns, provider);
    }

    protected JQueryAjaxBehavior newToolbarAjaxBehavior(IJQueryAjaxAware source) {
        return null;
    }

    protected JQueryAjaxBehavior newColumnAjaxBehavior(IJQueryAjaxAware source, ColumnButton button) {
        return new ColumnAjaxBehavior(source, button);
    }
}

