/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.console;

import com.googlecode.wicket.kendo.ui.console.AbstractConsole;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.IFeedback;

public class FeedbackConsole
extends AbstractConsole
implements IFeedback {
    private static final long serialVersionUID = 1L;
    private FeedbackMessagesModel feedbackMessagesModel;

    public FeedbackConsole(String id) {
        super(id);
    }

    public FeedbackConsole(String id, int capacity) {
        super(id, capacity);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.feedbackMessagesModel = this.newFeedbackMessagesModel();
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.log(this.feedbackMessagesModel.getObject());
    }

    protected void onDetach() {
        super.onDetach();
        this.feedbackMessagesModel.detach();
    }

    protected final void log(List<FeedbackMessage> messages) {
        for (FeedbackMessage message : messages) {
            this.log(message);
        }
    }

    protected final void log(List<FeedbackMessage> messages, AjaxRequestTarget target) {
        for (FeedbackMessage message : messages) {
            this.log(message, target);
        }
    }

    protected void log(FeedbackMessage message) {
        this.log(message.getMessage(), this.isError(message));
        message.markRendered();
    }

    protected void log(FeedbackMessage message, AjaxRequestTarget target) {
        this.log(message.getMessage(), this.isError(message), target);
        message.markRendered();
    }

    protected boolean isError(FeedbackMessage message) {
        return message.getLevel() >= 400;
    }

    public void refresh(AjaxRequestTarget target) {
        this.log(this.feedbackMessagesModel.getObject(), target);
    }

    protected FeedbackMessagesModel newFeedbackMessagesModel() {
        return new FeedbackMessagesModel((Component)this);
    }
}

