/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.util.lang.Generics;

public class JsonUtils {
    private JsonUtils() {
    }

    public static JSONArray toArray(String[] values) {
        ArrayList list = Generics.newArrayList((int)values.length);
        for (String value : values) {
            list.add(value);
        }
        return new JSONArray((Collection)list);
    }

    public static JSONArray toArray(Enum<?>[] values) {
        ArrayList list = Generics.newArrayList((int)values.length);
        for (Enum<?> value : values) {
            list.add(value.name());
        }
        return new JSONArray((Collection)list);
    }

    public static List<Object> toList(JSONArray values) {
        ArrayList list = Generics.newArrayList();
        if (values != null) {
            for (int i = 0; i < values.length(); ++i) {
                list.add(values.get(i));
            }
        }
        return list;
    }

    public static List<JSONObject> toJSONList(JSONArray values) {
        ArrayList list = Generics.newArrayList();
        if (values != null) {
            for (int i = 0; i < values.length(); ++i) {
                list.add(values.getJSONObject(i));
            }
        }
        return list;
    }

    public static String toString(List<?> list) {
        return new JSONArray(list).toString();
    }

    public static String toString(Object object) {
        return new JSONObject(object).toString();
    }
}

