/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.StringValue;

public class RequestCycleUtils {
    private RequestCycleUtils() {
    }

    public static AjaxRequestTarget getAjaxRequestTarget() {
        return RequestCycle.get().find(AjaxRequestTarget.class).orElse(null);
    }

    public static IPartialPageRequestHandler getRequestHandler() {
        return RequestCycle.get().find(IPartialPageRequestHandler.class).orElse(null);
    }

    public static Class<? extends IRequestablePage> getPageClass() {
        IPageClassRequestHandler handler = (IPageClassRequestHandler)RequestCycle.get().find(IPageClassRequestHandler.class).get();
        if (handler != null) {
            return handler.getPageClass();
        }
        return null;
    }

    public static StringValue getQueryParameterValue(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        return parameters.getParameterValue(name);
    }

    public static List<StringValue> getQueryParameterValues(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        return parameters.getParameterValues(name);
    }

    public static StringValue getPostParameterValue(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getPostParameters();
        return parameters.getParameterValue(name);
    }

    public static List<StringValue> getPostParameterValues(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getPostParameters();
        return parameters.getParameterValues(name);
    }
}

