/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.googlecode.wicket.jquery.core.utils;

/**
 * Utility class for javascript / jQuery statements
 * 
 * @author Sebastien Briquet - sebfz1
 * 
 */
public class JQueryUtils
{
	/**
	 * Wraps a js statement into a try-catch block
	 * 
	 * @param statement the js statement
	 * @return the wrapped statement
	 */
	public static String trycatch(String statement)
	{
		return JQueryUtils.trycatch(statement, false);
	}

	/**
	 * Wraps a js statement into a try-catch block
	 * 
	 * @param statement the js statement
	 * @param warn whether a warn should be logged to the console
	 * @return the wrapped statement
	 */
	public static String trycatch(String statement, boolean warn)
	{
		return "try { " + statement + " } catch (e) { " + (warn ? "if (console) { console.warn(e); }" : "") + " }";
	}

	/**
	 * Utility class
	 */
	private JQueryUtils()
	{
	}
}
