/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPageClassRequestHandler;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCycleUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestCycleUtils.class);

    private RequestCycleUtils() {
    }

    public static AjaxRequestTarget getAjaxRequestTarget() {
        return (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
    }

    public static IPartialPageRequestHandler getRequestHandler() {
        return (IPartialPageRequestHandler)RequestCycle.get().find(IPartialPageRequestHandler.class);
    }

    public static Class<? extends IRequestablePage> getPageClass() {
        IPageClassRequestHandler handler = (IPageClassRequestHandler)RequestCycle.get().find(IPageClassRequestHandler.class);
        if (handler != null) {
            return handler.getPageClass();
        }
        return null;
    }

    public static boolean hasQueryParameter(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        for (String param : parameters.getParameterNames()) {
            if (!name.equals(param)) continue;
            return true;
        }
        return false;
    }

    public static StringValue getQueryParameterValue(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        return parameters.getParameterValue(name);
    }

    public static List<StringValue> getQueryParameterValues(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getQueryParameters();
        return parameters.getParameterValues(name);
    }

    public static StringValue getPostParameterValue(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getPostParameters();
        return parameters.getParameterValue(name);
    }

    public static List<StringValue> getPostParameterValues(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getPostParameters();
        return parameters.getParameterValues(name);
    }

    public static StringValue getRequestParameterValue(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getRequestParameters();
        return parameters.getParameterValue(name);
    }

    public static List<StringValue> getRequestParameterValues(String name) {
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters parameters = requestCycle.getRequest().getRequestParameters();
        return parameters.getParameterValues(name);
    }

    public static void log(IRequestParameters parameters) {
        log.info("--IRequestParameters--");
        for (String name : parameters.getParameterNames()) {
            log.info("{}: {}", (Object)name, (Object)parameters.getParameterValue(name));
        }
    }
}

