/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import com.googlecode.wicket.jquery.core.renderer.IChoiceRenderer;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;

public class RendererUtils {
    public static <T> String toJson(T object, ITextRenderer<? super T> renderer) {
        return String.format("{ %s }", RendererUtils.getJsonBody(object, renderer));
    }

    public static <T> String getJsonBody(T object, ITextRenderer<? super T> renderer) {
        return String.format("%1$s%2$s%1$s: %1$s%3$s%1$s", "\"", renderer.getTextField(), renderer.getText(object));
    }

    public static <T> String getJsonBody(T object, ITextRenderer<? super T> renderer, String property) {
        return String.format("%1$s%2$s%1$s: %1$s%3$s%1$s", "\"", property, renderer.getText(object, property));
    }

    public static <T> String toJson(T object, IChoiceRenderer<? super T> renderer) {
        return String.format("{ %s }", RendererUtils.getJsonBody(object, renderer));
    }

    public static <T> String getJsonBody(T object, IChoiceRenderer<? super T> renderer) {
        return String.format("%1$s%2$s%1$s: %1$s%3$s%1$s, %1$s%4$s%1$s: %1$s%5$s%1$s", "\"", renderer.getTextField(), renderer.getText(object), renderer.getValueField(), renderer.getValue(object));
    }

    private RendererUtils() {
    }
}

