/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.renderer;

import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import org.apache.wicket.core.util.lang.PropertyResolver;

public class TextRenderer<T>
implements ITextRenderer<T> {
    private static final long serialVersionUID = 1L;
    public static final String TEXT_FIELD = "text";
    private final String expression;

    public TextRenderer() {
        this.expression = null;
    }

    public TextRenderer(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getTextField() {
        String expression = this.getExpression();
        if (expression != null) {
            return expression;
        }
        return TEXT_FIELD;
    }

    @Override
    public String getText(T object) {
        if (this.expression != null) {
            return this.getText(object, this.expression);
        }
        return object != null ? object.toString() : "";
    }

    @Override
    public String getText(T object, String expression) {
        Object value;
        if (expression != null && (value = PropertyResolver.getValue((String)expression, object)) != null) {
            return value.toString();
        }
        return "";
    }

    @Override
    public boolean match(T object, String search, boolean sensitive) {
        if (!sensitive) {
            return this.getText(object).toLowerCase().contains(search.toLowerCase());
        }
        return this.getText(object).contains(search);
    }
}

