/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.behavior;

import com.googlecode.wicket.jquery.core.data.IChoiceProvider;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.core.utils.RendererUtils;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;

public abstract class ChoiceModelBehavior<T>
extends AbstractAjaxBehavior
implements IChoiceProvider<T> {
    private static final long serialVersionUID = 1L;
    protected final ITextRenderer<? super T> renderer;

    public ChoiceModelBehavior(ITextRenderer<? super T> renderer) {
        this.renderer = renderer;
    }

    protected List<String> getProperties() {
        return Collections.emptyList();
    }

    public void onRequest() {
        RequestCycle.get().scheduleRequestHandlerAfterCurrent(this.newRequestHandler());
    }

    protected IRequestHandler newRequestHandler() {
        return new ChoiceModelRequestHandler();
    }

    protected class ChoiceModelRequestHandler
    implements IRequestHandler {
        protected ChoiceModelRequestHandler() {
        }

        public void respond(IRequestCycle requestCycle) {
            WebResponse response = (WebResponse)requestCycle.getResponse();
            String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
            response.setContentType("application/json; charset=" + encoding);
            response.disableCaching();
            List choices = ChoiceModelBehavior.this.getChoices();
            if (choices != null) {
                int index = 0;
                StringBuilder builder = new StringBuilder("[");
                for (Object choice : choices) {
                    if (index++ > 0) {
                        builder.append(", ");
                    }
                    builder.append("{ ");
                    builder.append(RendererUtils.getJsonBody(choice, ChoiceModelBehavior.this.renderer));
                    for (String property : ChoiceModelBehavior.this.getProperties()) {
                        builder.append(", ");
                        builder.append(RendererUtils.getJsonBody(choice, ChoiceModelBehavior.this.renderer, property));
                    }
                    builder.append(" }");
                }
                response.write((CharSequence)builder.append("]"));
            }
        }

        public void detach(IRequestCycle requestCycle) {
        }
    }
}

