/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    private static final String ISO8601 = "yyyy-MM-dd'T'HH:mmZ";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public static long utc(Date date) {
        return DateUtils.utc(date.getTime());
    }

    public static long utc(long date) {
        return date - DateUtils.offset(date);
    }

    public static long offset(long time) {
        return TimeZone.getDefault().getOffset(time);
    }

    public static String toISO8601(Date date) {
        return new SimpleDateFormat(ISO8601).format(date);
    }

    public static long addHours(long date, int hours) {
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.setTimeInMillis(date);
        calendar.add(10, hours);
        return calendar.getTimeInMillis();
    }

    public static Date addHours(Date date, int hours) {
        Calendar calendar = Calendar.getInstance(UTC);
        calendar.setTime(date);
        calendar.add(10, hours);
        return calendar.getTime();
    }

    private DateUtils() {
    }
}

