/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core;

import com.googlecode.wicket.jquery.core.settings.JQueryLibrarySettings;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class JQueryAbstractBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ResourceReference> references;

    public static JQueryLibrarySettings getJQueryLibrarySettings() {
        if (Application.exists() && Application.get().getJavaScriptLibrarySettings() instanceof JQueryLibrarySettings) {
            return (JQueryLibrarySettings)Application.get().getJavaScriptLibrarySettings();
        }
        return null;
    }

    public JQueryAbstractBehavior(String name) {
        this.name = name;
        this.references = new ArrayList<ResourceReference>();
    }

    public boolean add(ResourceReference reference) {
        return this.references.add(reference);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        JQueryLibrarySettings settings = JQueryAbstractBehavior.getJQueryLibrarySettings();
        if (settings != null && settings.getJQueryGlobalizeReference() != null) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getJQueryGlobalizeReference())));
        }
        for (ResourceReference reference : this.references) {
            if (reference instanceof CssResourceReference) {
                response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CssHeaderItem.forReference((ResourceReference)reference)));
            }
            if (!(reference instanceof JavaScriptResourceReference)) continue;
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)reference)));
        }
        AjaxRequestTarget target = RequestCycleUtils.getAjaxRequestTarget();
        if (target != null) {
            target.appendJavaScript((CharSequence)this.$());
        } else {
            this.renderScript((JavaScriptHeaderItem)JavaScriptHeaderItem.forScript((CharSequence)this.toString(), (String)this.getToken()), response);
        }
    }

    protected void renderScript(JavaScriptHeaderItem script, IHeaderResponse response) {
        response.render((HeaderItem)script);
    }

    protected abstract String $();

    protected String getToken() {
        return String.format("jquery-%s-%d", this.name, ((Object)((Object)this)).hashCode());
    }

    public String toString() {
        return String.format("jQuery(function() { %s });", this.$());
    }
}

