/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.utils;

import com.googlecode.wicket.jquery.core.renderer.IChoiceRenderer;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import org.apache.wicket.ajax.json.JSONObject;

public class RendererUtils {
    public static <T> String toJson(T object, ITextRenderer<? super T> renderer) {
        return String.format("{ %s }", RendererUtils.getJsonBody(object, renderer));
    }

    public static <T> String getJsonBody(T object, ITextRenderer<? super T> renderer) {
        return String.format("%s: %s", JSONObject.quote((String)renderer.getTextField()), JSONObject.quote((String)renderer.getText(object)));
    }

    public static <T> String getJsonBody(T object, ITextRenderer<? super T> renderer, String property) {
        return String.format("%s: %s", JSONObject.quote((String)property), JSONObject.quote((String)renderer.getText(object, property)));
    }

    public static <T> String toJson(T object, IChoiceRenderer<? super T> renderer) {
        return String.format("{ %s }", RendererUtils.getJsonBody(object, renderer));
    }

    public static <T> String getJsonBody(T object, IChoiceRenderer<? super T> renderer) {
        return String.format("%s: %s, %s: %s", JSONObject.quote((String)renderer.getTextField()), JSONObject.quote((String)renderer.getText(object)), JSONObject.quote((String)renderer.getValueField()), JSONObject.quote((String)renderer.getValue(object)));
    }

    private RendererUtils() {
    }
}

