/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.core.Options;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;

public class JQueryBehavior
extends JQueryAbstractBehavior {
    private static final long serialVersionUID = 1L;
    private static final String NULL_OPTIONS = "Options have not been defined (null has been supplied to the constructor)";
    protected String selector = null;
    protected final String method;
    protected final Options options;
    private List<String> events = null;

    public JQueryBehavior(String selector) {
        this(selector, "");
    }

    public JQueryBehavior(String selector, String method) {
        this(selector, method, new Options());
    }

    public JQueryBehavior(String selector, String method, Options options) {
        super(method);
        this.method = method;
        this.options = options;
        this.selector = selector;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.events != null) {
            StringBuilder statements = new StringBuilder("jQuery(function() { ");
            for (String event : this.events) {
                statements.append(event);
            }
            statements.append(" });");
            response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)statements, (String)(this.getToken() + "-events")));
        }
    }

    public String getSelector() {
        return this.selector;
    }

    protected void setSelector(String selector) {
        this.selector = selector;
    }

    public String getMethod() {
        return this.method;
    }

    public <T> T getOption(String key) {
        if (this.options == null) {
            throw new WicketRuntimeException(NULL_OPTIONS);
        }
        return this.options.get(key);
    }

    public JQueryBehavior setOption(String key, Object value) {
        if (this.options == null) {
            throw new WicketRuntimeException(NULL_OPTIONS);
        }
        this.options.set(key, value);
        return this;
    }

    public JQueryBehavior setOption(String key, Object ... values) {
        if (this.options == null) {
            throw new WicketRuntimeException(NULL_OPTIONS);
        }
        this.options.set(key, values);
        return this;
    }

    public JQueryBehavior setOption(String key, List<?> values) {
        if (this.options == null) {
            throw new WicketRuntimeException(NULL_OPTIONS);
        }
        this.options.set(key, values);
        return this;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        for (Map.Entry<String, Object> option : options.entries()) {
            this.setOption(option.getKey(), option.getValue());
        }
    }

    protected void on(String event, String callback) {
        this.on(this.selector, event, callback);
    }

    protected void on(String selector, String event, String callback) {
        this.on(String.format("jQuery('%s').on('%s', %s);", selector, event, callback));
    }

    protected synchronized void on(String statement) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        this.events.add(statement);
    }

    @Override
    protected String $() {
        return JQueryBehavior.$(this.selector, this.method, this.options.toString());
    }

    public String $(Object ... options) {
        return this.$(Options.fromArray(options));
    }

    public String $(String options) {
        return JQueryBehavior.$(this.selector, this.method, options);
    }

    private static String $(String selector, String method, String options) {
        return String.format("jQuery('%s').%s(%s);", selector, method, options);
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (component instanceof IJQueryWidget) {
            ((IJQueryWidget)component).onConfigure(this);
        }
    }

    public void beforeRender(Component component) {
        super.beforeRender(component);
        if (component instanceof IJQueryWidget) {
            ((IJQueryWidget)component).onBeforeRender(this);
        }
    }
}

