/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.wizard;

import com.googlecode.wicket.jquery.ui.panel.JQueryFeedbackPanel;
import com.googlecode.wicket.jquery.ui.widget.dialog.AbstractFormDialog;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButton;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.wizard.IWizard;
import org.apache.wicket.extensions.wizard.IWizardModel;
import org.apache.wicket.extensions.wizard.IWizardModelListener;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;

public abstract class AbstractWizard<T extends Serializable>
extends AbstractFormDialog<T>
implements IWizardModelListener,
IWizard {
    private static final long serialVersionUID = 1L;
    private IWizardModel wizardModel;
    private Form<T> form;
    private FeedbackPanel feedback;
    private DialogButton btnPrev;
    private DialogButton btnNext;
    private DialogButton btnLast;
    private DialogButton btnFinish;
    private DialogButton btnCancel;

    public AbstractWizard(String id, String title) {
        super(id, title);
    }

    public AbstractWizard(String id, IModel<String> title) {
        super(id, title);
    }

    public AbstractWizard(String id, String title, IWizardModel wizardModel) {
        super(id, title);
        this.init(wizardModel);
    }

    public AbstractWizard(String id, IModel<String> title, IWizardModel wizardModel) {
        super(id, title);
        this.init(wizardModel);
    }

    public AbstractWizard(String id, String title, boolean modal) {
        super(id, title, modal);
    }

    public AbstractWizard(String id, IModel<String> title, boolean modal) {
        super(id, title, modal);
    }

    public AbstractWizard(String id, String title, IModel<T> model, boolean modal) {
        super(id, title, model, modal);
    }

    public AbstractWizard(String id, IModel<String> title, IModel<T> model, boolean modal) {
        super(id, title, model, modal);
    }

    public AbstractWizard(String id, String title, IModel<T> model) {
        super(id, title, model);
    }

    public AbstractWizard(String id, IModel<String> title, IModel<T> model) {
        super(id, title, model);
    }

    protected void init(IWizardModel wizardModel) {
        if (wizardModel == null) {
            throw new IllegalArgumentException("argument wizardModel must be not null");
        }
        this.wizardModel = wizardModel;
        this.wizardModel.addListener((IWizardModelListener)this);
        this.form = new Form("form");
        this.add(new Component[]{this.form});
        this.form.add(new Component[]{new EmptyPanel("header")});
        this.feedback = new JQueryFeedbackPanel("feedback");
        this.form.add(new Component[]{this.feedback});
        this.form.add(new Component[]{new EmptyPanel("view")});
    }

    public FeedbackPanel getFeedbackPanel() {
        return this.feedback;
    }

    @Override
    protected void onInitialize() {
        this.btnPrev = new DialogButton(this.getString("wizard.button.prev"));
        this.btnNext = new DialogButton(this.getString("wizard.button.next"));
        this.btnLast = new DialogButton(this.getString("wizard.button.last"));
        this.btnFinish = new DialogButton(this.getString("wizard.button.finish"));
        this.btnCancel = new DialogButton(this.getString("wizard.button.cancel"));
        super.onInitialize();
    }

    protected void onConfigure(AjaxRequestTarget target) {
        this.btnPrev.setEnabled(this.wizardModel.isPreviousAvailable(), target);
        this.btnNext.setEnabled(this.wizardModel.isNextAvailable(), target);
        this.btnLast.setEnabled(this.wizardModel.isLastAvailable(), target);
        this.btnLast.setVisible(this.wizardModel.isLastVisible(), target);
        this.btnCancel.setVisible(this.wizardModel.isCancelVisible(), target);
        boolean enabled = this.wizardModel.isLastStep(this.wizardModel.getActiveStep());
        this.btnFinish.setEnabled(enabled, target);
        target.add(new Component[]{this.form});
    }

    @Override
    protected void onOpen(AjaxRequestTarget target) {
        super.onOpen(target);
        this.wizardModel.reset();
        this.onConfigure(target);
    }

    @Override
    protected final void onClick(DialogEvent event) {
        AjaxRequestTarget target = event.getTarget();
        if (event.isClicked(this.getSubmitButton())) {
            this.onFinish();
            this.onFinish(target);
            this.close(target, this.getSubmitButton());
        } else if (event.isClicked(this.getCancelButton())) {
            this.onCancel();
            this.onCancel(target);
            this.close(target, this.getCancelButton());
        } else {
            if (event.isClicked(this.btnPrev)) {
                this.getWizardModel().previous();
            } else if (event.isClicked(this.btnNext)) {
                this.getWizardModel().next();
            } else if (event.isClicked(this.btnLast)) {
                this.getWizardModel().last();
            }
            this.onConfigure(target);
        }
    }

    @Override
    protected void onSubmit(AjaxRequestTarget target) {
        IWizardModel wizardModel = this.getWizardModel();
        wizardModel.getActiveStep().applyState();
    }

    @Override
    protected final void onError(AjaxRequestTarget target) {
        target.add(new Component[]{this.feedback});
    }

    public void onFinish() {
    }

    public void onCancel() {
    }

    protected abstract void onFinish(AjaxRequestTarget var1);

    protected void onCancel(AjaxRequestTarget target) {
    }

    public IWizardModel getWizardModel() {
        return this.wizardModel;
    }

    public void onActiveStepChanged(IWizardStep step) {
        this.form.replace(step.getHeader("header", (Component)this, (IWizard)this));
        this.form.replace(step.getView("view", (Component)this, (IWizard)this));
    }

    @Override
    protected List<DialogButton> getButtons() {
        return Arrays.asList(this.btnPrev, this.btnNext, this.btnLast, this.btnFinish, this.btnCancel);
    }

    @Override
    protected DialogButton getSubmitButton() {
        return this.btnFinish;
    }

    protected DialogButton getCancelButton() {
        return this.btnCancel;
    }

    @Override
    public Form<?> getForm() {
        return this.form;
    }

    @Override
    protected Form<?> getForm(DialogButton button) {
        if (button.equals(this.btnNext) || button.equals(this.btnLast)) {
            return this.getForm();
        }
        return super.getForm(button);
    }
}

