/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.tabs;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.JQueryPanel;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.widget.tabs.AjaxTab;
import com.googlecode.wicket.jquery.ui.widget.tabs.TabsBehavior;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class TabbedPanel
extends JQueryPanel {
    private static final long serialVersionUID = 1L;
    private final List<ITab> tabs;
    private TabsBehavior widgetBehavior;
    private JQueryAjaxBehavior activateEventBehavior;

    public TabbedPanel(String id, List<ITab> tabs) {
        this(id, tabs, new Options());
    }

    public TabbedPanel(String id, List<ITab> tabs, Options options) {
        super(id, options);
        this.tabs = tabs;
        this.init();
    }

    private void init() {
        final RepeatingView panels = new RepeatingView("panels"){
            private static final long serialVersionUID = 1L;

            public String newChildId() {
                return String.format("tab-%s-%s", this.getMarkupId(), super.newChildId());
            }

            protected void onConfigure() {
                super.onConfigure();
                this.removeAll();
            }
        };
        this.add(new Component[]{panels});
        this.add(new Component[]{new ListView<ITab>("tabs", (IModel)new ListModel(this.tabs)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<ITab> item) {
                ITab tab = (ITab)item.getModelObject();
                if (tab.isVisible()) {
                    String newId = panels.newChildId();
                    Label link = new Label("link", tab.getTitle());
                    link.add(new Behavior[]{AttributeModifier.replace((String)"href", (Serializable)((Object)("#" + newId)))});
                    item.add(new Component[]{link});
                    panels.add(new Component[]{tab.getPanel(newId).setMarkupId(newId).setOutputMarkupId(true)});
                }
            }
        }});
    }

    public List<ITab> getTabs() {
        return this.tabs;
    }

    public TabbedPanel setActiveTab(int index) {
        this.options.set("active", Integer.valueOf(index));
        return this;
    }

    public void setActiveTab(int index, AjaxRequestTarget target) {
        this.widgetBehavior.activate(index, target);
    }

    public boolean add(ITab tab) {
        return this.tabs.add(tab);
    }

    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.activateEventBehavior = this.newActivateEventBehavior();
        behaviorArray[0] = this.activateEventBehavior;
        this.add(behaviorArray);
        Behavior[] behaviorArray2 = new Behavior[1];
        this.widgetBehavior = (TabsBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior(this);
        behaviorArray2[0] = this.widgetBehavior;
        this.add(behaviorArray2);
    }

    protected void onConfigure(JQueryBehavior behavior) {
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ActivateEvent) {
            ActivateEvent payload = (ActivateEvent)event.getPayload();
            AjaxRequestTarget target = payload.getTarget();
            int index = payload.getIndex();
            if (index > -1) {
                ITab tab = this.tabs.get(index);
                if (tab instanceof AjaxTab) {
                    ((AjaxTab)tab).load(target);
                }
                this.onActivate(target, index, tab);
            }
        }
    }

    protected void onActivate(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new TabsBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                TabbedPanel.this.onConfigure(this);
                this.setOption("create", (Serializable)((Object)TabbedPanel.this.activateEventBehavior.getCallbackFunction()));
                this.setOption("activate", (Serializable)((Object)TabbedPanel.this.activateEventBehavior.getCallbackFunction()));
            }
        };
    }

    private JQueryAjaxBehavior newActivateEventBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"index", (String)"jQuery(event.target).tabs('option', 'active')")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new ActivateEvent(target);
            }
        };
    }

    private class ActivateEvent
    extends JQueryEvent {
        private final int index;

        public ActivateEvent(AjaxRequestTarget target) {
            super(target);
            this.index = RequestCycleUtils.getQueryParameterValue("index").toInt(-1);
        }

        public int getIndex() {
            return this.index;
        }
    }
}

