/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.menu;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.JQueryPanel;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.widget.menu.IMenuItem;
import com.googlecode.wicket.jquery.ui.widget.menu.MenuBehavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class Menu
extends JQueryPanel {
    private static final long serialVersionUID = 1L;
    private final List<IMenuItem> items;
    private WebMarkupContainer root;
    private Map<String, IMenuItem> map = new HashMap<String, IMenuItem>();
    private JQueryAjaxBehavior onSelectBehavior;

    public Menu(String id) {
        this(id, new ArrayList<IMenuItem>());
    }

    public Menu(String id, List<IMenuItem> items) {
        super(id);
        this.items = items;
        this.init();
    }

    public Menu(String id, Options options) {
        this(id, new ArrayList<IMenuItem>(), options);
    }

    public Menu(String id, List<IMenuItem> items, Options options) {
        super(id, options);
        this.items = items;
        this.init();
    }

    private void init() {
        this.root = new WebMarkupContainer("root");
        this.root.add(new Component[]{new ListFragment("list", this.items)});
        this.add(new Component[]{this.root});
    }

    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.onSelectBehavior = this.newOnSelectBehavior();
        behaviorArray[0] = this.onSelectBehavior;
        this.add(behaviorArray);
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, IJQueryWidget.JQueryWidget.getSelector((Component)this.root))});
    }

    protected void onConfigure(JQueryBehavior behavior) {
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof SelectEvent) {
            SelectEvent payload = (SelectEvent)event.getPayload();
            AjaxRequestTarget target = payload.getTarget();
            IMenuItem item = this.map.get(payload.getHash());
            if (item != null) {
                item.onClick(target);
                this.onClick(target, item);
            }
        }
    }

    protected void onClick(AjaxRequestTarget target, IMenuItem item) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new MenuBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                Menu.this.onConfigure(this);
                this.setOption("select", (Serializable)((Object)Menu.this.onSelectBehavior.getCallbackFunction()));
            }
        };
    }

    private JQueryAjaxBehavior newOnSelectBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"id", (String)"ui.item.context.id")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new SelectEvent(target);
            }
        };
    }

    private class ItemFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public ItemFragment(String id, IMenuItem item) {
            super(id, "item-fragment", (MarkupContainer)Menu.this);
            this.add(new Component[]{new EmptyPanel("icon").add(new Behavior[]{AttributeModifier.append((String)"class", (IModel)new PropertyModel((Object)item, "iconClass"))})});
            this.add(new Component[]{new Label("title", item.getTitle())});
        }
    }

    private class ListFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public ListFragment(String id, List<IMenuItem> items) {
            super(id, "list-fragment", (MarkupContainer)Menu.this);
            this.add(new Component[]{new ListView<IMenuItem>("items", items){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<IMenuItem> item) {
                    IMenuItem menuItem = (IMenuItem)item.getModelObject();
                    Menu.this.map.put(menuItem.getId(), menuItem);
                    item.add(new Behavior[]{AttributeModifier.replace((String)"id", (Serializable)((Object)menuItem.getId()))});
                    item.add(new Component[]{new ItemFragment("item", menuItem)});
                    item.add(new Component[]{new MenuFragment("menu", menuItem.getItems())});
                    if (!menuItem.isEnabled()) {
                        item.add(new Behavior[]{AttributeModifier.append((String)"class", (IModel)Model.of((Serializable)((Object)"ui-state-disabled")))});
                    }
                }
            }});
        }
    }

    private class MenuFragment
    extends Fragment {
        private static final long serialVersionUID = 1L;

        public MenuFragment(String id, List<IMenuItem> items) {
            super(id, "menu-fragment", (MarkupContainer)Menu.this);
            this.add(new Component[]{new ListFragment("list", items)});
            this.setVisible(items.size() > 0);
        }
    }

    private class SelectEvent
    extends JQueryEvent {
        private final String hash;

        public SelectEvent(AjaxRequestTarget target) {
            super(target);
            this.hash = RequestCycleUtils.getQueryParameterValue("id").toString();
        }

        public String getHash() {
            return this.hash;
        }
    }
}

