/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.dialog;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.JQueryPanel;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.interaction.behavior.DisplayNoneBehavior;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButton;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class AbstractDialog<T extends Serializable>
extends JQueryPanel {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "dialog";
    public static final String LBL_OK = "OK";
    public static final String LBL_NO = "No";
    public static final String LBL_YES = "Yes";
    public static final String LBL_CLOSE = "Close";
    public static final String LBL_CANCEL = "Cancel";
    public static final String LBL_SUBMIT = "Submit";
    private static final int WIDTH = 450;
    private IModel<String> title;
    private boolean modal;
    private JQueryBehavior widgetBehavior;
    private JQueryAjaxBehavior onDefaultClose;
    private final DialogButton btnOk = new DialogButton("OK");

    public AbstractDialog(String id, String title) {
        this(id, title, null, true);
    }

    public AbstractDialog(String id, IModel<String> title) {
        this(id, title, null, true);
    }

    public AbstractDialog(String id, String title, IModel<T> model) {
        this(id, title, model, true);
    }

    public AbstractDialog(String id, IModel<String> title, IModel<T> model) {
        this(id, title, model, true);
    }

    public AbstractDialog(String id, String title, boolean modal) {
        this(id, title, null, modal);
    }

    public AbstractDialog(String id, IModel<String> title, boolean modal) {
        this(id, title, null, modal);
    }

    public AbstractDialog(String id, String title, IModel<T> model, boolean modal) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), model, modal);
    }

    public AbstractDialog(String id, IModel<String> title, IModel<T> model, boolean modal) {
        super(id, model);
        this.title = title;
        this.modal = modal;
        this.add(new Behavior[]{new DisplayNoneBehavior()});
        this.setOutputMarkupPlaceholderTag(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        for (DialogButton button : this.getButtons()) {
            this.add(new Behavior[]{this.newButtonAjaxBehavior(button)});
        }
        Behavior[] behaviorArray = new Behavior[1];
        this.onDefaultClose = this.newDefaultCloseBehavior();
        behaviorArray[0] = this.onDefaultClose;
        this.add(behaviorArray);
        Behavior[] behaviorArray2 = new Behavior[1];
        this.widgetBehavior = IJQueryWidget.JQueryWidget.newWidgetBehavior(this);
        behaviorArray2[0] = this.widgetBehavior;
        this.add(behaviorArray2);
    }

    protected void onConfigure(JQueryBehavior behavior) {
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof DialogEvent) {
            this.onClick((DialogEvent)event.getPayload());
        } else if (event.getPayload() instanceof CloseEvent) {
            AjaxRequestTarget target = ((CloseEvent)event.getPayload()).getTarget();
            this.onClose(target, null);
        }
    }

    protected void onOpen(AjaxRequestTarget target) {
    }

    protected void onClick(DialogEvent event) {
        this.close(event.getTarget(), event.getButton());
    }

    protected abstract void onClose(AjaxRequestTarget var1, DialogButton var2);

    protected List<DialogButton> getButtons() {
        return Arrays.asList(this.btnOk);
    }

    public int getWidth() {
        return 450;
    }

    public IModel<String> getTitle() {
        return this.title;
    }

    public void setTitle(IModel<String> title) {
        if (title == null) {
            throw new IllegalArgumentException("argument title must be not null");
        }
        this.title = title;
    }

    public boolean isModal() {
        return this.modal;
    }

    public boolean isResizable() {
        return false;
    }

    protected boolean isDefaultCloseEventEnabled() {
        return false;
    }

    public IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public T getModelObject() {
        return (T)((Serializable)this.getDefaultModelObject());
    }

    public void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }

    public DialogButton findButton(String text) {
        for (DialogButton button : this.getButtons()) {
            if (button == null || !button.equals(text)) continue;
            return button;
        }
        return null;
    }

    public final void open(AjaxRequestTarget target) {
        this.onOpen(target);
        if (this.widgetBehavior != null) {
            target.appendJavaScript((CharSequence)this.widgetBehavior.$("'open'"));
        }
    }

    public final void close(AjaxRequestTarget target, DialogButton button) {
        if (this.widgetBehavior != null) {
            target.appendJavaScript((CharSequence)this.widgetBehavior.$("'close'"));
        }
        this.onClose(target, button);
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new JQueryBehavior(selector, METHOD){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                AbstractDialog.this.onConfigure(this);
                this.setOption("autoOpen", Boolean.valueOf(false));
                this.setOption("title", (Serializable)((Object)Options.asString((String)AbstractDialog.this.title.getObject())));
                this.setOption("modal", Boolean.valueOf(AbstractDialog.this.modal));
                this.setOption("resizable", Boolean.valueOf(AbstractDialog.this.isResizable()));
                this.setOption("width", Integer.valueOf(AbstractDialog.this.getWidth()));
                if (AbstractDialog.this.isDefaultCloseEventEnabled()) {
                    this.setOption("close", (Serializable)((Object)AbstractDialog.this.onDefaultClose.getCallbackFunction()));
                }
                StringBuffer buttons = new StringBuffer("[ ");
                int index = 0;
                for (ButtonAjaxBehavior behavior : AbstractDialog.this.getBehaviors(ButtonAjaxBehavior.class)) {
                    DialogButton button = behavior.getButton();
                    if (index++ > 0) {
                        buttons.append(", ");
                    }
                    buttons.append("{");
                    buttons.append("'id': '").append(button.getMarkupId()).append("', ");
                    buttons.append("'text': '").append(button.toString()).append("', ");
                    if (!button.isEnabled()) {
                        buttons.append("'disabled': true, ");
                    }
                    buttons.append("'click': function() { ").append(behavior.getCallbackScript()).append(" }");
                    buttons.append("}");
                }
                buttons.append(" ]");
                this.setOption("buttons", buttons);
            }
        };
    }

    protected ButtonAjaxBehavior newButtonAjaxBehavior(DialogButton button) {
        return new ButtonAjaxBehavior(this, button);
    }

    protected JQueryAjaxBehavior newDefaultCloseBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            public String getCallbackFunction() {
                return "function(event, ui) { if (event.button == 0) { " + this.getCallbackScript() + " } }";
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new CloseEvent(target);
            }
        };
    }

    static class CloseEvent
    extends JQueryEvent {
        public CloseEvent(AjaxRequestTarget target) {
            super(target);
        }
    }

    class ButtonAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final DialogButton button;

        public ButtonAjaxBehavior(AbstractDialog<T> dialog, DialogButton button) {
            super((Component)dialog);
            this.button = button;
        }

        public DialogButton getButton() {
            return this.button;
        }

        @Override
        protected JQueryEvent newEvent(AjaxRequestTarget target) {
            return new DialogEvent(target, this.button);
        }
    }
}

