/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.accordion;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.JQueryPanel;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.widget.accordion.AccordionBehavior;
import com.googlecode.wicket.jquery.ui.widget.tabs.AjaxTab;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AccordionPanel
extends JQueryPanel {
    private static final long serialVersionUID = 1L;
    private final List<ITab> tabs;
    private AccordionBehavior widgetBehavior;
    private JQueryAjaxBehavior activateEventBehavior;

    public AccordionPanel(String id, List<ITab> tabs) {
        this(id, tabs, new Options());
    }

    public AccordionPanel(String id, List<ITab> tabs, Options options) {
        super(id, options);
        this.tabs = tabs;
        this.init();
    }

    private void init() {
        this.add(new Component[]{new Loop("tabs", (IModel)this.getCountModel()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(LoopItem item) {
                int index = item.getIndex();
                ITab tab = (ITab)AccordionPanel.this.tabs.get(index);
                if (tab.isVisible()) {
                    item.add(new Component[]{new Label("title", tab.getTitle())});
                    item.add(new Component[]{tab.getPanel("panel")});
                }
            }
        }});
    }

    public AccordionPanel setActiveTab(int index) {
        this.options.set("active", Integer.valueOf(index));
        return this;
    }

    public void setActiveTab(int index, AjaxRequestTarget target) {
        this.widgetBehavior.activate(index, target);
    }

    private Model<Integer> getCountModel() {
        return new Model<Integer>(){
            private static final long serialVersionUID = 1L;

            public Integer getObject() {
                return AccordionPanel.this.tabs.size();
            }
        };
    }

    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.activateEventBehavior = this.newActivateEventBehavior();
        behaviorArray[0] = this.activateEventBehavior;
        this.add(behaviorArray);
        Behavior[] behaviorArray2 = new Behavior[1];
        this.widgetBehavior = (AccordionBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior(this);
        behaviorArray2[0] = this.widgetBehavior;
        this.add(behaviorArray2);
    }

    protected void onConfigure(JQueryBehavior behavior) {
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ActivateEvent) {
            ActivateEvent payload = (ActivateEvent)event.getPayload();
            AjaxRequestTarget target = payload.getTarget();
            int index = payload.getIndex();
            if (index > -1) {
                ITab tab = this.tabs.get(index);
                if (tab instanceof AjaxTab) {
                    ((AjaxTab)tab).load(target);
                }
                this.onActivate(target, index, tab);
            }
        }
    }

    protected void onActivate(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new AccordionBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                AccordionPanel.this.onConfigure(this);
                this.setOption("create", (Serializable)((Object)AccordionPanel.this.activateEventBehavior.getCallbackFunction()));
                this.setOption("activate", (Serializable)((Object)AccordionPanel.this.activateEventBehavior.getCallbackFunction()));
            }
        };
    }

    private JQueryAjaxBehavior newActivateEventBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"index", (String)"jQuery(event.target).accordion('option', 'active')")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new ActivateEvent(target);
            }
        };
    }

    private class ActivateEvent
    extends JQueryEvent {
        private final int index;

        public ActivateEvent(AjaxRequestTarget target) {
            super(target);
            this.index = RequestCycleUtils.getQueryParameterValue("index").toInt(-1);
        }

        public int getIndex() {
            return this.index;
        }
    }
}

