/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget;

import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryContainer;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.event.JQueryAjaxChangeBehavior;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;

public class ProgressBar
extends JQueryContainer {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "progressbar";
    private static final int MIN = 0;
    private static final int MAX = 100;
    private JQueryAjaxBehavior onChangeBehavior = null;

    public ProgressBar(String id) {
        super(id);
    }

    public ProgressBar(String id, IModel<Integer> model) {
        super(id, model);
    }

    public IModel<Integer> getModel() {
        return this.getDefaultModel();
    }

    public Integer getModelObject() {
        return (Integer)this.getDefaultModelObject();
    }

    public void setModelObject(Integer value) {
        if (value < 0) {
            value = 0;
        } else if (value > 100) {
            value = 100;
        }
        this.setDefaultModelObject(value);
    }

    public void forward(AjaxRequestTarget target) {
        this.forward(target, 1);
    }

    public final void forward(AjaxRequestTarget target, int step) {
        this.setModelObject(this.getModelObject() + step);
        this.respond(target);
    }

    public final void backward(AjaxRequestTarget target) {
        this.backward(target, 1);
    }

    public final void backward(AjaxRequestTarget target, int step) {
        this.setModelObject(this.getModelObject() - step);
        this.respond(target);
    }

    public final void respond(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)this.widgetBehavior.toString());
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.onChangeBehavior = this.newOnChangeBehavior();
        behaviorArray[0] = this.onChangeBehavior;
        this.add(behaviorArray);
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof JQueryAjaxChangeBehavior.ChangeEvent) {
            JQueryEvent payload = (JQueryEvent)event.getPayload();
            AjaxRequestTarget target = payload.getTarget();
            this.onValueChanged(target);
            if (this.getModelObject() == 100) {
                this.onComplete(target);
            }
        }
    }

    protected void onModelChanged() {
        this.widgetBehavior.setOption("value", this.getModelObject());
    }

    protected void onValueChanged(AjaxRequestTarget target) {
    }

    protected void onComplete(AjaxRequestTarget target) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new JQueryBehavior(selector, METHOD){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                this.setOption("value", ProgressBar.this.getModelObject());
                this.setOption("change", (Serializable)((Object)ProgressBar.this.onChangeBehavior.getCallbackFunction()));
            }
        };
    }

    private JQueryAjaxBehavior newOnChangeBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new JQueryAjaxChangeBehavior.ChangeEvent(target);
            }
        };
    }
}

