/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.panel;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.FeedbackPanel;

public class JQueryFeedbackPanel
extends FeedbackPanel {
    private static final long serialVersionUID = 1L;
    public static final String INFO_ICO = "ui-icon ui-icon-info";
    public static final String INFO_CSS = "ui-state-highlight ui-corner-all";
    public static final String WARN_ICO = "ui-icon ui-icon-alert";
    public static final String WARN_CSS = "ui-state-highlight ui-corner-all";
    public static final String LIGHT_ICO = "ui-icon ui-icon-lightbulb";
    public static final String LIGHT_CSS = "ui-state-highlight ui-corner-all";
    public static final String ERROR_ICO = "ui-icon ui-icon-alert";
    public static final String ERROR_CSS = "ui-state-error ui-corner-all";

    public JQueryFeedbackPanel(String id) {
        super(id);
        this.init();
    }

    public JQueryFeedbackPanel(String id, Component filter) {
        super(id, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(filter));
        this.init();
    }

    public JQueryFeedbackPanel(String id, MarkupContainer filter) {
        super(id, (IFeedbackMessageFilter)new ContainerFeedbackMessageFilter(filter));
        this.init();
    }

    private void init() {
        this.setOutputMarkupId(true);
    }

    protected Component newMessageDisplayComponent(String id, FeedbackMessage message) {
        WebMarkupContainer container = new WebMarkupContainer(id);
        container.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)this.getMessageClass(message)))});
        container.add(new Component[]{new EmptyPanel("icon").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)this.getIconClass(message)))})});
        container.add(new Component[]{super.newMessageDisplayComponent("label", message)});
        return container;
    }

    protected String getCSSClass(FeedbackMessage message) {
        return "";
    }

    protected String getMessageClass(FeedbackMessage message) {
        switch (message.getLevel()) {
            case 200: {
                return "ui-state-highlight ui-corner-all";
            }
            case 300: {
                return "ui-state-highlight ui-corner-all";
            }
            case 400: {
                return ERROR_CSS;
            }
        }
        return this.getCSSClass(message);
    }

    protected String getIconClass(FeedbackMessage message) {
        switch (message.getLevel()) {
            case 200: {
                return INFO_ICO;
            }
            case 300: {
                return "ui-icon ui-icon-alert";
            }
            case 400: {
                return "ui-icon ui-icon-alert";
            }
        }
        return this.getCSSClass(message);
    }
}

