/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.panel;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class FormSubmittingPanel<T>
extends GenericPanel<T>
implements IFormSubmittingComponent {
    private static final long serialVersionUID = 1L;
    private boolean processForm = true;

    public FormSubmittingPanel(String id) {
        super(id);
    }

    public FormSubmittingPanel(String id, IModel<T> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new HiddenField("submitter", (IModel)new Model()).add(new Behavior[]{AttributeModifier.replace((String)"name", (Serializable)((Object)this.getInputName()))})});
    }

    public void submit(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("jQuery('%s').submit();", IJQueryWidget.JQueryWidget.getSelector(this.getForm())));
    }

    public Form<?> getForm() {
        return Form.findForm((Component)this);
    }

    public String getInputName() {
        return Form.getRootFormRelativeId((Component)this);
    }

    public final boolean getDefaultFormProcessing() {
        return this.processForm;
    }

    public final FormSubmittingPanel<T> setDefaultFormProcessing(boolean processForm) {
        this.processForm = processForm;
        return this;
    }

    public void onAfterSubmit() {
    }
}

