/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction.resizable;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.JQueryPanel;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.interaction.resizable.ResizableBehavior;
import com.googlecode.wicket.jquery.ui.utils.RequestCycleUtils;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;

public abstract class ResizablePanel
extends JQueryPanel {
    private static final long serialVersionUID = 1L;
    private JQueryAjaxBehavior onResizeStartBehavior;
    private JQueryAjaxBehavior onResizeStopBehavior;

    public ResizablePanel(String id) {
        super(id);
    }

    public ResizablePanel(String id, Options options) {
        super(id, options);
    }

    public ResizablePanel(String id, IModel<?> model) {
        super(id, model);
    }

    public ResizablePanel(String id, IModel<?> model, Options options) {
        super(id, model, options);
    }

    protected boolean isResizeStartEventEnabled() {
        return false;
    }

    protected boolean isResizeStopEventEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.onResizeStartBehavior = this.newOnResizeStartBehavior();
        behaviorArray[0] = this.onResizeStartBehavior;
        this.add(behaviorArray);
        Behavior[] behaviorArray2 = new Behavior[1];
        this.onResizeStopBehavior = this.newOnResizeStopBehavior();
        behaviorArray2[0] = this.onResizeStopBehavior;
        this.add(behaviorArray2);
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior(this)});
    }

    protected void onConfigure(JQueryBehavior behavior) {
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof ResizeEvent) {
            ResizeEvent payload = (ResizeEvent)event.getPayload();
            AjaxRequestTarget target = payload.getTarget();
            if (payload instanceof ResizeStartEvent) {
                this.onResizeStart(target, payload.getTop(), payload.getLeft(), payload.getWidth(), payload.getHeight());
            }
            if (payload instanceof ResizeStopEvent) {
                this.onResizeStop(target, payload.getTop(), payload.getLeft(), payload.getWidth(), payload.getHeight());
            }
        }
    }

    protected void onResizeStart(AjaxRequestTarget target, int top, int left, int width, int height) {
    }

    protected void onResizeStop(AjaxRequestTarget target, int top, int left, int width, int height) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new ResizableBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                ResizablePanel.this.onConfigure(this);
                if (ResizablePanel.this.isResizeStartEventEnabled()) {
                    this.setOption("start", (Serializable)((Object)ResizablePanel.this.onResizeStartBehavior.getCallbackFunction()));
                }
                if (ResizablePanel.this.isResizeStopEventEnabled()) {
                    this.setOption("stop", (Serializable)((Object)ResizablePanel.this.onResizeStopBehavior.getCallbackFunction()));
                }
            }
        };
    }

    private JQueryAjaxBehavior newOnResizeStartBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"top", (String)"ui.position.top"), CallbackParameter.resolved((String)"left", (String)"ui.position.left"), CallbackParameter.resolved((String)"width", (String)"ui.size.width"), CallbackParameter.resolved((String)"height", (String)"ui.size.height")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new ResizeStartEvent(target);
            }
        };
    }

    private JQueryAjaxBehavior newOnResizeStopBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"top", (String)"ui.position.top"), CallbackParameter.resolved((String)"left", (String)"ui.position.left"), CallbackParameter.resolved((String)"width", (String)"ui.size.width"), CallbackParameter.resolved((String)"height", (String)"ui.size.height")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new ResizeStopEvent(target);
            }
        };
    }

    protected class ResizeStopEvent
    extends ResizeEvent {
        public ResizeStopEvent(AjaxRequestTarget target) {
            super(target);
        }
    }

    protected class ResizeStartEvent
    extends ResizeEvent {
        public ResizeStartEvent(AjaxRequestTarget target) {
            super(target);
        }
    }

    private class ResizeEvent
    extends JQueryEvent {
        private final int top;
        private final int left;
        private final int width;
        private final int height;

        public ResizeEvent(AjaxRequestTarget target) {
            super(target);
            this.top = RequestCycleUtils.getQueryParameterValue("top").toInt(-1);
            this.left = RequestCycleUtils.getQueryParameterValue("left").toInt(-1);
            this.width = RequestCycleUtils.getQueryParameterValue("width").toInt(-1);
            this.height = RequestCycleUtils.getQueryParameterValue("height").toInt(-1);
        }

        public int getTop() {
            return this.top;
        }

        public int getLeft() {
            return this.left;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

