/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryContainer;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.interaction.Draggable;
import com.googlecode.wicket.jquery.ui.interaction.SelectableBehavior;
import com.googlecode.wicket.jquery.ui.interaction.SelectableDraggableFactory;
import com.googlecode.wicket.jquery.ui.utils.RequestCycleUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.util.string.StringValue;

public class Selectable<T extends Serializable>
extends JQueryContainer {
    private static final long serialVersionUID = 1L;
    private JQueryAjaxBehavior onStopBehavior;
    private List<T> items;

    public Selectable(String id, List<T> list) {
        this(id, (IModel<List<T>>)new ListModel(list));
    }

    public Selectable(String id, IModel<List<T>> model) {
        super(id, model);
    }

    public List<T> getModelObject() {
        return (List)this.getDefaultModelObject();
    }

    public List<T> getSelectedItems() {
        return this.items;
    }

    protected String getItemSelector() {
        return "li";
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.onStopBehavior = this.newOnStopBehavior();
        behaviorArray[0] = this.onStopBehavior;
        this.add(behaviorArray);
    }

    protected void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("filter", (Serializable)((Object)Options.asString(this.getItemSelector())));
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof StopEvent) {
            StopEvent payload = (StopEvent)event.getPayload();
            this.items = new ArrayList<T>();
            List<T> list = this.getModelObject();
            for (int index : payload.getIndexes()) {
                if (index >= list.size()) continue;
                this.items.add(list.get(index));
            }
            this.onSelect(payload.getTarget(), this.items);
        }
    }

    protected void onSelect(AjaxRequestTarget target, List<T> list) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new SelectableBehavior(selector){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                Selectable.this.onConfigure(this);
                this.setOption("stop", (Serializable)((Object)Selectable.this.onStopBehavior.getCallbackFunction()));
            }
        };
    }

    protected JQueryAjaxBehavior newOnStopBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.resolved((String)"indexes", (String)"indexes")};
            }

            public CharSequence getCallbackFunctionBody(CallbackParameter ... parameters) {
                String selector = String.format("%s %s", IJQueryWidget.JQueryWidget.getSelector((Component)Selectable.this), Selectable.this.getItemSelector());
                String indexes = "var indexes=[]; jQuery('.ui-selected', this).each( function() { indexes.push(jQuery('" + selector + "').index(this)); } ); ";
                return indexes + super.getCallbackFunctionBody(parameters);
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new StopEvent(target);
            }
        };
    }

    public Draggable<?> createDraggable(String id) {
        return this.createDraggable(id, new DefaultDraggableFactory());
    }

    public Draggable<?> createDraggable(String id, SelectableDraggableFactory factory) {
        return factory.create(id, IJQueryWidget.JQueryWidget.getSelector((Component)this));
    }

    class DefaultDraggableFactory
    extends SelectableDraggableFactory {
        private static final long serialVersionUID = 1L;

        DefaultDraggableFactory() {
        }

        @Override
        protected Draggable<?> create(String id, String selector, final String helper) {
            Draggable draggable = new Draggable<T>(id){
                private static final long serialVersionUID = 1L;

                @Override
                protected void onConfigure(JQueryBehavior behavior) {
                    super.onConfigure(behavior);
                    behavior.setOption("helper", (Serializable)((Object)helper));
                }
            };
            draggable.add(new Behavior[]{AttributeModifier.append((String)"class", (Serializable)((Object)"ui-icon ui-icon-arrow-4-diag"))});
            draggable.add(new Behavior[]{AttributeModifier.append((String)"style", (Serializable)((Object)"display: inline-block; background-position: -16px -80px !important;"))});
            return draggable;
        }
    }

    protected class StopEvent
    extends JQueryEvent {
        private final List<Integer> indexes;

        public StopEvent(AjaxRequestTarget target) {
            super(target);
            this.indexes = new ArrayList<Integer>();
            StringValue values = RequestCycleUtils.getQueryParameterValue("indexes");
            if (values != null) {
                Pattern pattern = Pattern.compile("(\\d+)");
                Matcher matcher = pattern.matcher(values.toString());
                while (matcher.find()) {
                    this.indexes.add(Integer.valueOf(matcher.group()));
                }
            }
        }

        public List<Integer> getIndexes() {
            return this.indexes;
        }
    }
}

