/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.spinner;

import com.googlecode.wicket.jquery.ui.IJQueryCultureWidget;
import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.Options;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;

public class Spinner<T extends Number>
extends TextField<T>
implements IJQueryCultureWidget {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "spinner";
    private Options options;

    public Spinner(String id) {
        this(id, new Options());
    }

    public Spinner(String id, Options options) {
        this(id, options, null);
    }

    public Spinner(String id, Class<T> type) {
        this(id, new Options(), type);
    }

    public Spinner(String id, Options options, Class<T> type) {
        super(id, type);
        this.options = options;
    }

    public Spinner(String id, IModel<T> model) {
        this(id, model, new Options(), null);
    }

    public Spinner(String id, IModel<T> model, Options options) {
        this(id, model, options, null);
    }

    public Spinner(String id, IModel<T> model, Class<T> type) {
        this(id, model, new Options(), type);
    }

    public Spinner(String id, IModel<T> model, Options options, Class<T> type) {
        super(id, model, type);
        this.options = options;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior(this)});
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setDisabled(!this.isEnabled());
    }

    protected void onConfigure(JQueryBehavior behavior) {
    }

    @Override
    public Spinner<T> setCulture(String culture) {
        this.options.set("culture", (Serializable)((Object)Options.asString(culture)));
        return this;
    }

    @Override
    public String getCulture() {
        return (String)((Object)this.options.get("culture"));
    }

    private Spinner<T> setDisabled(boolean disabled) {
        this.options.set("disabled", Boolean.valueOf(disabled));
        return this;
    }

    public Spinner<T> setMin(Number min) {
        this.options.set("min", min);
        return this;
    }

    public Spinner<T> setMin(String min) {
        this.options.set("min", (Serializable)((Object)Options.asString(min)));
        return this;
    }

    public Spinner<T> setMax(Number max) {
        this.options.set("max", max);
        return this;
    }

    public Spinner<T> setMax(String max) {
        this.options.set("max", (Serializable)((Object)Options.asString(max)));
        return this;
    }

    public Spinner<T> setPage(Number steps) {
        this.options.set("page", steps);
        return this;
    }

    public Spinner<T> setStep(Number size) {
        this.options.set("step", size);
        return this;
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new JQueryBehavior(selector, METHOD, this.options){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                Spinner.this.onConfigure(this);
            }
        };
    }
}

