/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.datepicker;

import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxPostBehavior;
import com.googlecode.wicket.jquery.ui.form.datepicker.DatePicker;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;

public class AjaxDatePicker
extends DatePicker {
    private static final long serialVersionUID = 1L;
    private JQueryAjaxBehavior onSelectBehavior;

    public AjaxDatePicker(String id) {
        super(id);
        this.init();
    }

    public AjaxDatePicker(String id, IModel<Date> model) {
        super(id, model);
        this.init();
    }

    private void init() {
        this.onSelectBehavior = this.newOnSelectBehavior((FormComponent<?>)this);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{this.onSelectBehavior});
    }

    @Override
    protected void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        behavior.setOption("onSelect", (Serializable)((Object)this.onSelectBehavior.getCallbackFunction()));
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof SelectEvent) {
            SelectEvent payload = (SelectEvent)event.getPayload();
            this.processInput();
            this.onValueChanged(payload.getTarget());
        }
    }

    protected void onValueChanged(AjaxRequestTarget target) {
    }

    private JQueryAjaxPostBehavior newOnSelectBehavior(FormComponent<?> component) {
        return new JQueryAjaxPostBehavior(component){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"dateText"), CallbackParameter.context((String)"inst")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new SelectEvent(target);
            }
        };
    }

    class SelectEvent
    extends JQueryEvent {
        public SelectEvent(AjaxRequestTarget target) {
            super(target);
        }
    }
}

