/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.button;

import com.googlecode.wicket.jquery.ui.IJQuerySecurityProvider;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryIcon;
import com.googlecode.wicket.jquery.ui.form.button.Button;
import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebSession;

public abstract class SecuredButton
extends Button {
    private static final long serialVersionUID = 1L;
    private final IJQuerySecurityProvider provider;
    private String[] roles;

    public SecuredButton(String id, String ... roles) {
        this(id, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredButton(String id, IJQuerySecurityProvider provider, String ... roles) {
        super(id);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredButton(String id, IModel<String> model, String ... roles) {
        this(id, model, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredButton(String id, IModel<String> model, IJQuerySecurityProvider provider, String ... roles) {
        super(id, model);
        this.roles = roles;
        this.provider = provider;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public final boolean isLocked() {
        return !this.provider.hasRole(this.roles);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setEnabled(!this.isLocked());
    }

    @Override
    protected void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("icons", (Serializable)((Object)String.format("{ primary: '%s' }", new Object[]{this.isLocked() ? JQueryIcon.LOCKED : JQueryIcon.UNLOCKED})));
    }
}

