/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.button;

import com.googlecode.wicket.jquery.ui.IJQuerySecurityProvider;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryIcon;
import com.googlecode.wicket.jquery.ui.form.button.AjaxButton;
import java.io.Serializable;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebSession;

public abstract class SecuredAjaxButton
extends AjaxButton {
    private static final long serialVersionUID = 1L;
    private String[] roles;
    private final IJQuerySecurityProvider provider;

    public SecuredAjaxButton(String id, String ... roles) {
        this(id, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredAjaxButton(String id, IJQuerySecurityProvider provider, String ... roles) {
        super(id);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredAjaxButton(String id, Form<?> form, String ... roles) {
        this(id, form, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredAjaxButton(String id, Form<?> form, IJQuerySecurityProvider provider, String ... roles) {
        super(id, form);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredAjaxButton(String id, IModel<String> model, String ... roles) {
        this(id, model, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredAjaxButton(String id, IModel<String> model, IJQuerySecurityProvider provider, String ... roles) {
        super(id, model);
        this.roles = roles;
        this.provider = provider;
    }

    public SecuredAjaxButton(String id, IModel<String> model, Form<?> form, String ... roles) {
        this(id, model, form, (IJQuerySecurityProvider)WebSession.get(), roles);
    }

    public SecuredAjaxButton(String id, IModel<String> model, Form<?> form, IJQuerySecurityProvider provider, String ... roles) {
        super(id, model, form);
        this.roles = roles;
        this.provider = provider;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public final boolean isLocked() {
        return !this.provider.hasRole(this.roles);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setEnabled(!this.isLocked());
    }

    @Override
    protected void onConfigure(JQueryBehavior behavior) {
        behavior.setOption("icons", (Serializable)((Object)String.format("{ primary: '%s' }", new Object[]{this.isLocked() ? JQueryIcon.LOCKED : JQueryIcon.UNLOCKED})));
    }
}

