/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.button;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;

public abstract class IndicatingAjaxButton
extends AjaxButton
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private Position position = Position.LEFT;

    public IndicatingAjaxButton(String id) {
        super(id);
    }

    public IndicatingAjaxButton(String id, Form<?> form) {
        super(id, form);
    }

    public IndicatingAjaxButton(String id, IModel<String> model) {
        super(id, model);
    }

    public IndicatingAjaxButton(String id, IModel<String> model, Form<?> form) {
        super(id, model, form);
    }

    public IndicatingAjaxButton setPosition(Position position) {
        this.position = position;
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior(this)});
    }

    protected void onError(AjaxRequestTarget target, Form<?> form) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new JQueryBehavior(selector, "button"){
            private static final long serialVersionUID = 1L;

            @Override
            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(AbstractDefaultAjaxBehavior.INDICATOR);
                response.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)(".ui-icon.ui-icon-indicator { background-image: url(" + ((Object)RequestCycle.get().urlFor((IRequestHandler)handler)).toString() + ") !important; background-position: 0 0; }"), (String)"jquery-ui-icon-indicator"));
                StringBuilder script = new StringBuilder("jQuery(function() {");
                script.append("jQuery('").append(this.selector).append("')");
                script.append(".click(function() { jQuery(this).button('option', 'icons', {").append(IndicatingAjaxButton.this.position == Position.LEFT ? "primary" : "secondary").append(": 'ui-icon-indicator' }); })");
                script.append(".ajaxStop(function() { jQuery(this).button('option', 'icons', {").append(IndicatingAjaxButton.this.position == Position.LEFT ? "primary" : "secondary").append(": null }); })");
                script.append("});");
                response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)script, (String)(((Object)((Object)this)).getClass().getName() + "-" + this.selector)));
            }
        };
    }

    public static enum Position {
        LEFT,
        RIGHT;

    }
}

