/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.autocomplete;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.form.autocomplete.AutoCompleteBehavior;
import com.googlecode.wicket.jquery.ui.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.ui.renderer.TextRenderer;
import com.googlecode.wicket.jquery.ui.template.IJQueryTemplate;
import com.googlecode.wicket.jquery.ui.template.JQueryTemplateBehavior;
import com.googlecode.wicket.jquery.ui.utils.RequestCycleUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public abstract class AutoCompleteTextField<T extends Serializable>
extends TextField<T>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "autocomplete";
    private AutoCompleteBehavior<T> sourceBehavior;
    private JQueryAjaxBehavior onSelectBehavior;
    private final ITextRenderer<? super T> renderer;
    private final IConverter<T> converter;
    private final IJQueryTemplate template;
    private JQueryTemplateBehavior templateBehavior = null;
    private List<T> choices;

    public AutoCompleteTextField(String id) {
        this(id, new TextRenderer(), null);
    }

    public AutoCompleteTextField(String id, Class<T> type) {
        this(id, new TextRenderer(), type);
    }

    public AutoCompleteTextField(String id, ITextRenderer<? super T> renderer) {
        this(id, renderer, null);
    }

    public AutoCompleteTextField(String id, ITextRenderer<? super T> renderer, Class<T> type) {
        super(id, type);
        this.renderer = renderer;
        this.template = this.newTemplate();
        this.converter = this.newConverter();
    }

    public AutoCompleteTextField(String id, IModel<T> model) {
        this(id, model, new TextRenderer(), null);
    }

    public AutoCompleteTextField(String id, IModel<T> model, Class<T> type) {
        this(id, model, new TextRenderer(), type);
    }

    public AutoCompleteTextField(String id, IModel<T> model, ITextRenderer<? super T> renderer) {
        this(id, model, renderer, null);
    }

    public AutoCompleteTextField(String id, IModel<T> model, ITextRenderer<? super T> renderer, Class<T> type) {
        super(id, model, type);
        this.renderer = renderer;
        this.template = this.newTemplate();
        this.converter = this.newConverter();
    }

    protected String getModelValue() {
        return this.renderer.getText(this.getModelObject());
    }

    protected abstract List<T> getChoices(String var1);

    private List<T> internalGetChoices(String input) {
        this.choices = this.getChoices(input);
        return this.choices;
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (!String.class.isAssignableFrom(this.getType()) && type != null && type.isAssignableFrom(this.getType())) {
            return this.converter;
        }
        return super.getConverter(type);
    }

    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.sourceBehavior = this.newAutoCompleteBehavior();
        behaviorArray[0] = this.sourceBehavior;
        this.add(behaviorArray);
        Behavior[] behaviorArray2 = new Behavior[1];
        this.onSelectBehavior = this.newSelectBehavior();
        behaviorArray2[0] = this.onSelectBehavior;
        this.add(behaviorArray2);
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior(this)});
        if (this.template != null) {
            Behavior[] behaviorArray3 = new Behavior[1];
            this.templateBehavior = new JQueryTemplateBehavior(this.template);
            behaviorArray3[0] = this.templateBehavior;
            this.add(behaviorArray3);
        }
    }

    protected void onConfigure(JQueryBehavior behavior) {
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put(METHOD, (CharSequence)"off");
    }

    public void onEvent(IEvent<?> event) {
        SelectEvent payload;
        int index;
        if (event.getPayload() instanceof SelectEvent && (index = (payload = (SelectEvent)event.getPayload()).getIndex()) < this.choices.size()) {
            Serializable choice = (Serializable)this.choices.get(index);
            this.setModelObject(choice);
            this.onSelected(payload.getTarget());
        }
    }

    protected void onSelected(AjaxRequestTarget target) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new JQueryBehavior(selector, METHOD){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                AutoCompleteTextField.this.onConfigure(this);
                this.setOption("source", (Serializable)((Object)Options.asString(AutoCompleteTextField.this.sourceBehavior.getCallbackUrl())));
                this.setOption("select", (Serializable)((Object)AutoCompleteTextField.this.onSelectBehavior.getCallbackFunction()));
            }

            @Override
            protected String $() {
                if (AutoCompleteTextField.this.templateBehavior != null) {
                    String render = "jQuery(function() { jQuery('%s').data('ui-autocomplete')._renderItem = function( ul, item ) { return jQuery('<li></li>').data('ui-autocomplete-item', item).append(jQuery.tmpl(jQuery('#%s').html(), item)).appendTo(ul); } });";
                    return super.$() + String.format(render, this.selector, AutoCompleteTextField.this.templateBehavior.getToken());
                }
                return super.$();
            }
        };
    }

    protected IJQueryTemplate newTemplate() {
        return null;
    }

    private IConverter<T> newConverter() {
        return new IConverter<T>(){
            private static final long serialVersionUID = 1L;

            public T convertToObject(String value, Locale locale) {
                if (value != null && value.equals(AutoCompleteTextField.this.getModelValue())) {
                    return (Serializable)AutoCompleteTextField.this.getModelObject();
                }
                return null;
            }

            public String convertToString(T value, Locale locale) {
                return AutoCompleteTextField.this.renderer.getText(value);
            }
        };
    }

    private AutoCompleteBehavior<T> newAutoCompleteBehavior() {
        return new AutoCompleteBehavior<T>(this.renderer){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<T> getChoices(String input) {
                return AutoCompleteTextField.this.internalGetChoices(input);
            }

            @Override
            protected List<String> getProperties() {
                if (AutoCompleteTextField.this.template != null) {
                    return AutoCompleteTextField.this.template.getTextProperties();
                }
                return super.getProperties();
            }
        };
    }

    private JQueryAjaxBehavior newSelectBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"index", (String)"ui.item.id")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new SelectEvent(target);
            }
        };
    }

    class SelectEvent
    extends JQueryEvent {
        private final int index;

        public SelectEvent(AjaxRequestTarget target) {
            super(target);
            this.index = RequestCycleUtils.getQueryParameterValue("index").toInt(1) - 1;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

