/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.autocomplete;

import com.googlecode.wicket.jquery.ui.renderer.ITextRenderer;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;

abstract class AutoCompleteBehavior<T>
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final String QUERY = "term";
    private static final String QUOTE = "\"";
    private final ITextRenderer<? super T> renderer;

    public AutoCompleteBehavior(ITextRenderer<? super T> renderer) {
        this.renderer = renderer;
    }

    protected abstract List<T> getChoices(String var1);

    protected List<String> getProperties() {
        return Collections.emptyList();
    }

    protected void respond(AjaxRequestTarget target) {
        RequestCycle requestCycle = RequestCycle.get();
        String value = requestCycle.getRequest().getQueryParameters().getParameterValue(QUERY).toString();
        IRequestHandler handler = this.newRequestHandler(value);
        requestCycle.scheduleRequestHandlerAfterCurrent(handler);
    }

    private IRequestHandler newRequestHandler(final String input) {
        return new IRequestHandler(){

            public void respond(IRequestCycle requestCycle) {
                WebResponse response = (WebResponse)requestCycle.getResponse();
                String encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
                response.setContentType("text/json; charset=" + encoding);
                response.disableCaching();
                List choices = AutoCompleteBehavior.this.getChoices(input);
                List<String> properties = AutoCompleteBehavior.this.getProperties();
                if (choices != null) {
                    StringBuilder builder = new StringBuilder("[ ");
                    int index = 0;
                    for (Object choice : choices) {
                        if (index++ > 0) {
                            builder.append(", ");
                        }
                        builder.append("{ ");
                        builder.append(AutoCompleteBehavior.QUOTE).append("id").append(AutoCompleteBehavior.QUOTE).append(": ").append(AutoCompleteBehavior.QUOTE).append(Integer.toString(index)).append(AutoCompleteBehavior.QUOTE);
                        builder.append(", ");
                        builder.append(AutoCompleteBehavior.QUOTE).append("value").append(AutoCompleteBehavior.QUOTE).append(": ").append(AutoCompleteBehavior.QUOTE).append(AutoCompleteBehavior.this.renderer.getText(choice)).append(AutoCompleteBehavior.QUOTE);
                        if (properties != null) {
                            for (String property : properties) {
                                builder.append(", ");
                                builder.append(AutoCompleteBehavior.QUOTE).append(property).append(AutoCompleteBehavior.QUOTE).append(": ").append(AutoCompleteBehavior.QUOTE).append(AutoCompleteBehavior.this.renderer.getText(choice, property)).append(AutoCompleteBehavior.QUOTE);
                            }
                        }
                        builder.append(" }");
                    }
                    builder.append(" ]");
                    response.write((CharSequence)builder);
                }
            }

            public void detach(IRequestCycle requestCycle) {
            }
        };
    }
}

