/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.effect;

import com.googlecode.wicket.jquery.ui.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;

public class JQueryEffectBehavior
extends JQueryAbstractBehavior {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "effect";
    private static final int SPEED = 500;
    private final String selector;
    private int speed;
    private String effect;
    private Options options;
    private JQueryAjaxBehavior callback = null;

    JQueryEffectBehavior(String selector) {
        this(selector, "");
    }

    public JQueryEffectBehavior(String selector, String effect) {
        this(selector, effect, new Options());
    }

    public JQueryEffectBehavior(String selector, String effect, Options options) {
        this(selector, effect, options, 500);
    }

    public JQueryEffectBehavior(String selector, String effect, int speed) {
        this(selector, effect, new Options(), speed);
    }

    public JQueryEffectBehavior(String selector, String effect, Options options, int speed) {
        super("effect-" + effect);
        this.selector = selector;
        this.effect = effect;
        this.options = options;
        this.speed = speed;
    }

    public void setCallback(JQueryAjaxBehavior callback) {
        this.callback = callback;
    }

    @Override
    protected String $() {
        return this.$(this.effect, this.options.toString());
    }

    public String $(String effect) {
        return this.$(effect, "''");
    }

    public String $(String effect, String options) {
        return JQueryEffectBehavior.$(this.selector, effect, options, this.speed, String.format("%s", this.callback != null ? this.callback.getCallbackScript() : ""));
    }

    private static String $(String selector, String effect, String options, int speed, String callback) {
        return String.format("jQuery(function() { jQuery('%s').%s('%s', %s, %d, function() { %s }); });", selector, METHOD, effect, options, speed, callback);
    }
}

