/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.ajax;

import com.googlecode.wicket.jquery.ui.JQueryEvent;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.util.time.Duration;

public abstract class JQueryAjaxBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final Component source;
    private final Duration duration;

    public JQueryAjaxBehavior(Component source) {
        this(source, Duration.NONE);
    }

    public JQueryAjaxBehavior(Component source, Duration duration) {
        this.source = source;
        this.duration = duration;
    }

    protected void respond(AjaxRequestTarget target) {
        this.source.send(this.getSink(), this.getBroadcast(), (Object)this.newEvent(target));
    }

    protected Broadcast getBroadcast() {
        return Broadcast.EXACT;
    }

    protected IEventSink getSink() {
        return this.source;
    }

    protected abstract JQueryEvent newEvent(AjaxRequestTarget var1);

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        if (this.duration != Duration.NONE) {
            attributes.setThrottlingSettings(new ThrottlingSettings("jquery-throttle", this.duration));
        }
    }

    protected CallbackParameter[] getCallbackParameters() {
        return new CallbackParameter[0];
    }

    public String getCallbackFunction() {
        return ((Object)super.getCallbackFunction(this.getCallbackParameters())).toString();
    }
}

