/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui;

import com.googlecode.wicket.jquery.ui.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.ui.Options;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;

public class JQueryBehavior
extends JQueryAbstractBehavior {
    private static final long serialVersionUID = 1L;
    private static final String NULL_OPTIONS = "Options have not been defined (null has been supplied to the constructor)";
    protected final String selector;
    protected final String method;
    protected final Options options;
    private List<String> events = null;

    public JQueryBehavior(String selector) {
        this(selector, "");
    }

    public JQueryBehavior(String selector, String method) {
        this(selector, method, new Options());
    }

    public JQueryBehavior(String selector, String method, Options options) {
        super(method);
        this.method = method;
        this.options = options;
        this.selector = selector;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.events != null) {
            StringBuilder statements = new StringBuilder("jQuery(function() { ");
            for (String event : this.events) {
                statements.append(event);
            }
            statements.append(" });");
            response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)statements, (String)(this.getToken() + "-events")));
        }
    }

    public Object getOption(String key) {
        if (this.options == null) {
            throw new WicketRuntimeException(NULL_OPTIONS);
        }
        return this.options.get(key);
    }

    public JQueryBehavior setOption(String key, Serializable value) {
        if (this.options == null) {
            throw new WicketRuntimeException(NULL_OPTIONS);
        }
        this.options.set(key, value);
        return this;
    }

    public void setOptions(Options options) {
        for (Map.Entry<String, Serializable> option : options.entries()) {
            this.setOption(option.getKey(), option.getValue());
        }
    }

    protected void on(String event, String callback) {
        this.on(this.selector, event, callback);
    }

    protected synchronized void on(String selector, String event, String callback) {
        if (this.events == null) {
            this.events = new ArrayList<String>();
        }
        this.events.add(String.format("jQuery('%s').on('%s', %s);", selector, event, callback));
    }

    @Override
    protected String $() {
        return JQueryBehavior.$(this.selector, this.method, this.options.toString());
    }

    public String $(Object ... options) {
        return this.$(Options.fromList(options));
    }

    public String $(String options) {
        return JQueryBehavior.$(this.selector, this.method, options);
    }

    private static String $(String selector, String method, String options) {
        return String.format("jQuery(function() { jQuery('%s').%s(%s); });", selector, method, options);
    }
}

