/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui;

import com.googlecode.wicket.jquery.ui.settings.IJQueryLibrarySettings;
import com.googlecode.wicket.jquery.ui.settings.JQueryLibrarySettings;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class JQueryAbstractBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ResourceReference> references;

    public JQueryAbstractBehavior(String name) {
        this.name = name;
        this.references = new ArrayList<ResourceReference>();
    }

    public boolean add(ResourceReference reference) {
        return this.references.add(reference);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        IJQueryLibrarySettings settings = Application.exists() && Application.get().getJavaScriptLibrarySettings() instanceof IJQueryLibrarySettings ? (IJQueryLibrarySettings)Application.get().getJavaScriptLibrarySettings() : new JQueryLibrarySettings();
        if (settings.getJQueryUIReference() != null) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getJQueryUIReference()));
        }
        if (settings.getJQueryGlobalizeReference() != null) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getJQueryGlobalizeReference()));
        }
        for (ResourceReference reference : this.references) {
            if (reference instanceof CssResourceReference) {
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)reference));
            }
            if (!(reference instanceof JavaScriptResourceReference)) continue;
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)reference));
        }
        AjaxRequestTarget target = (AjaxRequestTarget)component.getRequestCycle().find(AjaxRequestTarget.class);
        if (target != null) {
            target.appendJavaScript((CharSequence)this.toString());
        } else {
            response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)this.toString(), (String)this.getToken()));
        }
    }

    String getToken() {
        return String.format("jquery-%s-%d", this.name, ((Object)((Object)this)).hashCode());
    }

    protected abstract String $();

    public final String toString() {
        return this.$();
    }
}

