/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.tabs;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.JQueryPanel;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.widget.tabs.AjaxTab;
import com.googlecode.wicket.jquery.ui.widget.tabs.TabsBehavior;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class TabbedPanel
extends JQueryPanel {
    private static final long serialVersionUID = 1L;
    private final Options options;
    private final List<ITab> tabs;
    private JQueryAjaxBehavior onShowBehavior;

    public TabbedPanel(String id, List<ITab> tabs) {
        this(id, tabs, new Options());
    }

    public TabbedPanel(String id, List<ITab> tabs, Options options) {
        super(id);
        this.tabs = tabs;
        this.options = options;
        this.init();
    }

    private void init() {
        final RepeatingView panels = new RepeatingView("panels"){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.removeAll();
            }
        };
        this.add(new Component[]{panels});
        this.add(new Component[]{new ListView<ITab>("tabs", (IModel)new ListModel(this.tabs)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<ITab> item) {
                ITab tab = (ITab)item.getModelObject();
                if (tab.isVisible()) {
                    String newId = panels.newChildId();
                    Label link = new Label("link", tab.getTitle());
                    link.add(new Behavior[]{AttributeModifier.replace((String)"href", (Serializable)((Object)("#" + newId)))});
                    item.add(new Component[]{link});
                    panels.add(new Component[]{tab.getPanel(newId).setMarkupId(newId).setOutputMarkupId(true)});
                }
            }
        }});
    }

    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.onShowBehavior = this.newOnShowBehavior();
        behaviorArray[0] = this.onShowBehavior;
        this.add(behaviorArray);
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior(this)});
    }

    protected void onConfigure(JQueryBehavior behavior) {
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ShowEvent) {
            ShowEvent payload = (ShowEvent)event.getPayload();
            AjaxRequestTarget target = payload.getTarget();
            int index = payload.getIndex();
            ITab tab = this.tabs.get(index);
            if (tab instanceof AjaxTab) {
                ((AjaxTab)tab).load(target);
            }
        }
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new TabsBehavior(selector, this.options){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                TabbedPanel.this.onConfigure(this);
                this.setOption("show", (Serializable)((Object)TabbedPanel.this.onShowBehavior.getCallbackFunction()));
            }
        };
    }

    private JQueryAjaxBehavior newOnShowBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"index", (String)"ui.index")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new ShowEvent(target);
            }
        };
    }

    static class ShowEvent
    extends JQueryEvent {
        private final int index = RequestCycleUtils.getQueryParameterValue("index").toInt();

        public ShowEvent(AjaxRequestTarget target) {
            super(target);
        }

        public int getIndex() {
            return this.index;
        }
    }
}

