/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.dialog;

import com.googlecode.wicket.jquery.ui.panel.JQueryFeedbackPanel;
import com.googlecode.wicket.jquery.ui.widget.dialog.AbstractFormDialog;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButton;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButtons;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class InputDialog<T extends Serializable>
extends AbstractFormDialog<T> {
    private static final long serialVersionUID = 1L;
    private final Form<?> form = new Form("form");

    public InputDialog(String id, String title, String label) {
        this(id, title, label, (IModel<T>)new Model());
    }

    public InputDialog(String id, String title, String label, IModel<T> model) {
        super(id, title, model, true);
        this.add(new Component[]{this.form});
        this.form.add(new Component[]{new Label("label", label)});
        this.form.add(new Component[]{new RequiredTextField("input", this.getModel())});
        JQueryFeedbackPanel feedback = new JQueryFeedbackPanel("feedback", this.form.get("input"));
        this.form.add(new Component[]{feedback.setOutputMarkupId(true)});
    }

    @Override
    public Form<?> getForm() {
        return this.form;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected List<DialogButton> getButtons() {
        return DialogButtons.OK_CANCEL.toList();
    }

    @Override
    protected DialogButton getSubmitButton() {
        return this.findButton("OK");
    }

    @Override
    protected void onOpen(AjaxRequestTarget target) {
        target.add(new Component[]{this.form.get("feedback")});
    }

    @Override
    public final void onError(AjaxRequestTarget target) {
        target.add(new Component[]{this.form.get("feedback")});
    }
}

