/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.dialog;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.io.IClusterable;

public class DialogButton
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static short sequence = 0;
    private final int id = this.nextSequence();
    private final String text;
    private boolean enabled;
    private boolean visible = true;

    public DialogButton(String text) {
        this(text, true);
    }

    public DialogButton(IModel<String> model) {
        this((String)model.getObject(), true);
    }

    public DialogButton(IModel<String> model, boolean enabled) {
        this((String)model.getObject(), enabled);
    }

    public DialogButton(String text, boolean enabled) {
        this.text = text;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(boolean enabled, AjaxRequestTarget target) {
        if (enabled) {
            this.enable(target);
        } else {
            this.disable(target);
        }
    }

    public void setVisible(boolean visible, AjaxRequestTarget target) {
        if (this.visible != visible) {
            this.visible = visible;
            if (this.visible) {
                this.show(target);
            } else {
                this.hide(target);
            }
        }
    }

    protected String getMarkupId() {
        return String.format("btn%02x", this.id).toLowerCase();
    }

    private synchronized int nextSequence() {
        short s = sequence;
        sequence = (short)(s + 1);
        return s % Short.MAX_VALUE;
    }

    private void enable(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("$('#%s').button('enable');", this.getMarkupId()));
    }

    private void disable(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("$('#%s').button('disable');", this.getMarkupId()));
    }

    private void show(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("$('#%s').show();", this.getMarkupId()));
    }

    private void hide(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)String.format("$('#%s').hide();", this.getMarkupId()));
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        return object != null && object.toString().equals(this.toString());
    }

    public String toString() {
        return this.text;
    }
}

