/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.dialog;

import com.googlecode.wicket.jquery.ui.widget.dialog.AbstractDialog;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButton;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogEvent;
import java.io.Serializable;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmitter;
import org.apache.wicket.model.IModel;

public abstract class AbstractFormDialog<T extends Serializable>
extends AbstractDialog<T> {
    private static final long serialVersionUID = 1L;

    public AbstractFormDialog(String id, String title) {
        super(id, title);
    }

    public AbstractFormDialog(String id, String title, IModel<T> model) {
        super(id, title, model, true);
    }

    public AbstractFormDialog(String id, String title, boolean modal) {
        super(id, title, modal);
    }

    public AbstractFormDialog(String id, String title, IModel<T> model, boolean modal) {
        super(id, title, model, modal);
    }

    protected abstract DialogButton getSubmitButton();

    public boolean getDefaultFormProcessing() {
        return true;
    }

    public abstract Form<?> getForm();

    protected Form<?> getForm(DialogButton button) {
        if (button.equals(this.getSubmitButton())) {
            return this.getForm();
        }
        return null;
    }

    @Override
    protected AbstractDialog.ButtonAjaxBehavior newButtonAjaxBehavior(DialogButton button) {
        return new FormButtonAjaxBehavior(this, button, this.getForm(button));
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof DialogEvent) {
            DialogEvent payload = (DialogEvent)event.getPayload();
            Form<?> form = this.getForm(payload.getButton());
            if (form != null) {
                form.process((IFormSubmitter)new DialogFormSubmitter(payload.getTarget()));
                if (!form.hasError()) {
                    this.onClick(payload);
                }
            } else {
                this.onClick(payload);
            }
        } else if (event.getPayload() instanceof AbstractDialog.CloseEvent) {
            AjaxRequestTarget target = ((AbstractDialog.CloseEvent)event.getPayload()).getTarget();
            this.onClose(target, null);
        }
    }

    protected abstract void onError(AjaxRequestTarget var1);

    protected abstract void onSubmit(AjaxRequestTarget var1);

    @Override
    protected void onClose(AjaxRequestTarget target, DialogButton button) {
    }

    class FormButtonAjaxBehavior
    extends AbstractDialog.ButtonAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final Form<?> form;

        public FormButtonAjaxBehavior(AbstractFormDialog<T> dialog, DialogButton button, Form<?> form) {
            super(dialog, button);
            this.form = form;
        }

        @Override
        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            if (this.form != null) {
                attributes.setFormId(this.form.getMarkupId());
            }
        }
    }

    protected class DialogFormSubmitter
    implements IFormSubmitter {
        private final AjaxRequestTarget target;

        public DialogFormSubmitter(AjaxRequestTarget target) {
            this.target = target;
        }

        public Form<?> getForm() {
            return AbstractFormDialog.this.getForm();
        }

        public boolean getDefaultFormProcessing() {
            return AbstractFormDialog.this.getDefaultFormProcessing();
        }

        public void onSubmit() {
            AbstractFormDialog.this.onSubmit(this.target);
        }

        public void onError() {
            AbstractFormDialog.this.onError(this.target);
        }

        public void onAfterSubmit() {
        }
    }
}

