/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.accordion;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.JQueryPanel;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.widget.accordion.AccordionBehavior;
import com.googlecode.wicket.jquery.ui.widget.tabs.AjaxTab;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class AccordionPanel
extends JQueryPanel {
    private static final long serialVersionUID = 1L;
    private final List<ITab> tabs;
    private final Options options;
    private JQueryAjaxBehavior onChangingBehavior;
    private JQueryAjaxBehavior onChangedBehavior;

    public AccordionPanel(String id, List<ITab> tabs) {
        this(id, tabs, new Options());
    }

    public AccordionPanel(String id, List<ITab> tabs, Options options) {
        super(id);
        this.tabs = tabs;
        this.options = options;
        this.init();
    }

    private void init() {
        this.add(new Component[]{new ListView<ITab>("tabs", (IModel)new ListModel(this.tabs)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<ITab> item) {
                ITab tab = (ITab)item.getModelObject();
                if (tab.isVisible()) {
                    item.add(new Component[]{new Label("title", tab.getTitle())});
                    item.add(new Component[]{tab.getPanel("panel")});
                }
            }
        }});
    }

    protected boolean isChangedEventEnabled() {
        return false;
    }

    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.onChangingBehavior = this.newOnChangingBehavior();
        behaviorArray[0] = this.onChangingBehavior;
        this.add(behaviorArray);
        Behavior[] behaviorArray2 = new Behavior[1];
        this.onChangedBehavior = this.newOnChangedBehavior();
        behaviorArray2[0] = this.onChangedBehavior;
        this.add(behaviorArray2);
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior(this)});
    }

    protected void onConfigure(JQueryBehavior behavior) {
        behavior.setOptions(this.options);
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ChangeEvent) {
            ChangeEvent payload = (ChangeEvent)event.getPayload();
            int index = payload.getIndex();
            ITab tab = this.tabs.get(index);
            AjaxRequestTarget target = payload.getTarget();
            if (payload.getStep() == ChangeEvent.Step.Start) {
                if (tab instanceof AjaxTab) {
                    ((AjaxTab)tab).load(target);
                }
                this.onChanging(target, index, tab);
            }
            if (payload.getStep() == ChangeEvent.Step.Stop) {
                this.onChanged(target, index, tab);
            }
        }
    }

    protected void onChanging(AjaxRequestTarget target, int index, ITab tab) {
    }

    protected void onChanged(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new AccordionBehavior(selector){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                AccordionPanel.this.onConfigure(this);
                this.setOption("changestart", (Serializable)((Object)AccordionPanel.this.onChangingBehavior.getCallbackFunction()));
                if (AccordionPanel.this.isChangedEventEnabled()) {
                    this.setOption("change", (Serializable)((Object)AccordionPanel.this.onChangedBehavior.getCallbackFunction()));
                }
            }
        };
    }

    private JQueryAjaxBehavior newOnChangingBehavior() {
        return new OnChangeBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new ChangeEvent(target, ChangeEvent.Step.Start);
            }
        };
    }

    private JQueryAjaxBehavior newOnChangedBehavior() {
        return new OnChangeBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new ChangeEvent(target, ChangeEvent.Step.Stop);
            }
        };
    }

    static class ChangeEvent
    extends JQueryEvent {
        private final Step step;
        private final int index;

        public ChangeEvent(AjaxRequestTarget target, Step step) {
            super(target);
            this.step = step;
            this.index = RequestCycleUtils.getQueryParameterValue("index").toInt();
        }

        public Step getStep() {
            return this.step;
        }

        public int getIndex() {
            return this.index;
        }

        static enum Step {
            Start,
            Stop;

        }
    }

    abstract class OnChangeBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnChangeBehavior(Component source) {
            super(source);
        }

        @Override
        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"index", (String)"ui.options.active")};
        }
    }
}

