/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction;

import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryContainer;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.interaction.Draggable;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;

public abstract class Droppable<T>
extends JQueryContainer {
    private static final long serialVersionUID = 1L;
    private JQueryAjaxBehavior onDropBehavior;
    private JQueryAjaxBehavior onOverBehavior;
    private JQueryAjaxBehavior onExitBehavior;
    private transient Draggable<?> draggable = null;

    public Droppable(String id) {
        super(id);
    }

    public Droppable(String id, IModel<T> model) {
        super(id, model);
    }

    protected boolean isOverEventEnabled() {
        return false;
    }

    protected boolean isExitEventEnabled() {
        return false;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.onDropBehavior = this.newOnDropBehavior();
        behaviorArray[0] = this.onDropBehavior;
        this.add(behaviorArray);
        Behavior[] behaviorArray2 = new Behavior[1];
        this.onOverBehavior = this.newOnOverBehavior();
        behaviorArray2[0] = this.onOverBehavior;
        this.add(behaviorArray2);
        Behavior[] behaviorArray3 = new Behavior[1];
        this.onExitBehavior = this.newOnExitBehavior();
        behaviorArray3[0] = this.onExitBehavior;
        this.add(behaviorArray3);
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof JQueryEvent) {
            JQueryEvent payload = (JQueryEvent)event.getPayload();
            if (payload instanceof Draggable.DragStartEvent) {
                this.draggable = (Draggable)event.getSource();
            } else if (payload instanceof DropEvent) {
                this.onDrop(payload.getTarget(), this.draggable);
            } else if (payload instanceof OverEvent) {
                this.onOver(payload.getTarget(), this.draggable);
            } else if (payload instanceof ExitEvent) {
                this.onExit(payload.getTarget(), this.draggable);
            }
        }
    }

    protected abstract void onDrop(AjaxRequestTarget var1, Draggable<?> var2);

    protected void onOver(AjaxRequestTarget target, Draggable<?> draggable) {
    }

    protected void onExit(AjaxRequestTarget target, Draggable<?> draggable) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new JQueryBehavior(selector, "droppable"){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                this.setOption("drop", (Serializable)((Object)Droppable.this.onDropBehavior.getCallbackFunction()));
                if (Droppable.this.isOverEventEnabled()) {
                    this.setOption("over", (Serializable)((Object)Droppable.this.onOverBehavior.getCallbackFunction()));
                }
                if (Droppable.this.isExitEventEnabled()) {
                    this.setOption("out", (Serializable)((Object)Droppable.this.onExitBehavior.getCallbackFunction()));
                }
            }
        };
    }

    private JQueryAjaxBehavior newOnDropBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new DropEvent(target);
            }
        };
    }

    private JQueryAjaxBehavior newOnOverBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new OverEvent(target);
            }
        };
    }

    private JQueryAjaxBehavior newOnExitBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new ExitEvent(target);
            }
        };
    }

    public class ExitEvent
    extends JQueryEvent {
        public ExitEvent(AjaxRequestTarget target) {
            super(target);
        }
    }

    public class OverEvent
    extends JQueryEvent {
        public OverEvent(AjaxRequestTarget target) {
            super(target);
        }
    }

    public class DropEvent
    extends JQueryEvent {
        public DropEvent(AjaxRequestTarget target) {
            super(target);
        }
    }
}

