/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.JQueryContainer;
import com.googlecode.wicket.jquery.ui.JQueryEvent;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.ajax.JQueryAjaxBehavior;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.model.IModel;

public class Draggable<T>
extends JQueryContainer {
    private static final long serialVersionUID = 1L;
    private JQueryAjaxBehavior onDragStartBehavior;
    private JQueryAjaxBehavior onDragStopBehavior;
    private Options options;

    public Draggable(String id) {
        super(id);
        this.init();
    }

    public Draggable(String id, IModel<T> model) {
        super(id, model);
        this.init();
    }

    private void init() {
        this.options = new Options();
    }

    public IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public T getModelObject() {
        return (T)this.getDefaultModelObject();
    }

    protected boolean isStopEventEnabled() {
        return false;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        Behavior[] behaviorArray = new Behavior[1];
        this.onDragStartBehavior = this.newOnDragStartBehavior();
        behaviorArray[0] = this.onDragStartBehavior;
        this.add(behaviorArray);
        Behavior[] behaviorArray2 = new Behavior[1];
        this.onDragStopBehavior = this.newOnDragStopBehavior();
        behaviorArray2[0] = this.onDragStopBehavior;
        this.add(behaviorArray2);
    }

    protected void onConfigure(JQueryBehavior behavior) {
        behavior.setOptions(this.options);
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof JQueryEvent && event.getSource() == this) {
            JQueryEvent payload = (JQueryEvent)event.getPayload();
            if (payload instanceof DragStartEvent) {
                this.onDragStart(payload.getTarget());
            }
            if (payload instanceof DragStopEvent) {
                this.onDragStop(payload.getTarget());
            }
        }
    }

    protected void onDragStart(AjaxRequestTarget target) {
    }

    protected void onDragStop(AjaxRequestTarget target) {
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new JQueryBehavior(selector, "draggable"){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                Draggable.this.onConfigure(this);
                this.setOption("start", (Serializable)((Object)Draggable.this.onDragStartBehavior.getCallbackFunction()));
                if (Draggable.this.isStopEventEnabled()) {
                    this.setOption("stop", (Serializable)((Object)Draggable.this.onDragStopBehavior.getCallbackFunction()));
                }
            }
        };
    }

    public Draggable<T> setAxis(Axis axis) {
        this.options.set("axis", (Serializable)((Object)axis));
        return this;
    }

    public Draggable<T> setGrid(List<Integer> grid) {
        if (grid.size() == 2) {
            this.options.set("grid", (Serializable)((Object)grid.toString()));
        }
        return this;
    }

    public Draggable<T> setContainment(Component component) {
        return this.setContainment(IJQueryWidget.JQueryWidget.getSelector(component));
    }

    public Draggable<T> setContainment(String selector) {
        this.options.set("containment", (Serializable)((Object)Options.asString(selector)));
        return this;
    }

    public Draggable<T> setContainment(Containment containment) {
        this.options.set("containment", (Serializable)((Object)containment));
        return this;
    }

    public Draggable<T> setRevert(Boolean revert) {
        this.options.set("revert", revert);
        return this;
    }

    private JQueryAjaxBehavior newOnDragStartBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected Broadcast getBroadcast() {
                return Broadcast.BREADTH;
            }

            @Override
            protected IEventSink getSink() {
                return Draggable.this.getPage();
            }

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new DragStartEvent(target);
            }
        };
    }

    private JQueryAjaxBehavior newOnDragStopBehavior() {
        return new JQueryAjaxBehavior((Component)this){
            private static final long serialVersionUID = 1L;

            @Override
            protected CallbackParameter[] getCallbackParameters() {
                return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui")};
            }

            @Override
            protected JQueryEvent newEvent(AjaxRequestTarget target) {
                return new DragStopEvent(target);
            }
        };
    }

    public class DragStopEvent
    extends JQueryEvent {
        public DragStopEvent(AjaxRequestTarget target) {
            super(target);
        }
    }

    public class DragStartEvent
    extends JQueryEvent {
        public DragStartEvent(AjaxRequestTarget target) {
            super(target);
        }
    }

    public static enum Containment {
        Parent("'parent'"),
        Document("'document'"),
        Window("'window'");

        private String containment;

        private Containment(String containment) {
            this.containment = containment;
        }

        public String toString() {
            return this.containment;
        }
    }

    public static enum Axis {
        X("'x'"),
        Y("'y'");

        private String axis;

        private Axis(String axis) {
            this.axis = axis;
        }

        public String toString() {
            return this.axis;
        }
    }
}

