/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.slider;

import com.googlecode.wicket.jquery.ui.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.form.slider.AbstractSlider;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;

public class Slider
extends AbstractSlider<Integer> {
    private static final long serialVersionUID = 1L;
    private IValidator<Integer> rangeValidator = null;
    protected AbstractTextComponent<Integer> input = null;

    public Slider(String id) {
        super(id);
        this.init();
    }

    public Slider(String id, IModel<Integer> model) {
        super(id, model);
        this.init();
    }

    public Slider(String id, IModel<Integer> model, Label label) {
        super(id, model, label);
        this.init();
    }

    public Slider(String id, IModel<Integer> model, TextField<Integer> input) {
        super(id, model);
        this.input = input;
        this.input.setRequired(true);
        this.input.setOutputMarkupId(true);
        this.input.add(new Behavior[]{this.newInputBehavior()});
        this.init();
    }

    @Override
    protected Fragment newInputFragment(String id) {
        Fragment fragment;
        if (this.input == null) {
            this.input = new HiddenField("input", this.getModel(), Integer.class);
            fragment = new Fragment(id, "input-fragment", (MarkupContainer)this);
            fragment.add(new Component[]{this.input.setOutputMarkupPlaceholderTag(true)});
        } else {
            fragment = super.newInputFragment(id);
        }
        return fragment;
    }

    @Override
    protected void convertInput() {
        this.setConvertedInput(this.input.getConvertedInput());
    }

    @Override
    public <W extends AbstractSlider<Integer>> W setRangeValidator(RangeValidator<Integer> validator) {
        this.rangeValidator = validator;
        return (W)this;
    }

    protected String getLabelPattern() {
        return "ui.value";
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        if (this.rangeValidator != null) {
            this.input.add(this.rangeValidator);
        }
    }

    @Override
    protected void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        StringBuilder statements = new StringBuilder();
        statements.append("$('#").append(this.input.getMarkupId()).append("').val(ui.value); ");
        if (this.labelId != null) {
            statements.append("$('#").append(this.labelId).append("').text(").append(this.getLabelPattern()).append("); ");
        }
        behavior.setOption("slide", (Serializable)((Object)String.format("function(event, ui) { %s }", statements)));
        behavior.setOption("value", (Serializable)this.getModelObject());
    }

    public Slider setRange(Range range) {
        this.options.set("range", (Serializable)((Object)range));
        return this;
    }

    private JQueryAbstractBehavior newInputBehavior() {
        return new JQueryAbstractBehavior("slider-input"){
            private static final long serialVersionUID = 1L;

            @Override
            protected String $() {
                StringBuilder statements = new StringBuilder();
                statements.append("$('#").append(Slider.this.input.getMarkupId()).append("').on('change', function() { ");
                statements.append("$('#").append(Slider.this.label.getMarkupId()).append("').slider('value', $(this).val()); ");
                statements.append("} );");
                return String.format("$(function() { %s });", statements);
            }
        };
    }

    public static enum Range {
        MIN("'min'"),
        MAX("'max'");

        private String range;

        private Range(String range) {
            this.range = range;
        }

        public String toString() {
            return this.range;
        }
    }
}

