/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.slider;

import com.googlecode.wicket.jquery.ui.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.form.slider.AbstractSlider;
import com.googlecode.wicket.jquery.ui.form.slider.RangeValue;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.RangeValidator;

public class RangeSlider
extends AbstractSlider<RangeValue> {
    private static final long serialVersionUID = 1L;
    private IValidator<Integer> rangeValidator = null;
    protected AbstractTextComponent<Integer> lower;
    protected AbstractTextComponent<Integer> upper;

    public RangeSlider(String id) {
        super(id);
        this.init();
    }

    public RangeSlider(String id, IModel<RangeValue> model) {
        super(id, model);
        this.init();
    }

    public RangeSlider(String id, IModel<RangeValue> model, Label label) {
        super(id, model, label);
        this.init();
    }

    public RangeSlider(String id, IModel<RangeValue> model, TextField<Integer> lower, TextField<Integer> upper) {
        super(id, model);
        this.lower = lower;
        this.lower.setRequired(true);
        this.lower.setOutputMarkupId(true);
        this.lower.add(new Behavior[]{this.newLowerBehavior()});
        this.upper = upper;
        this.upper.setRequired(true);
        this.upper.setOutputMarkupId(true);
        this.upper.add(new Behavior[]{this.newUpperBehavior()});
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.setRange(true);
    }

    @Override
    protected void convertInput() {
        Integer lower = (Integer)this.lower.getConvertedInput();
        Integer upper = (Integer)this.upper.getConvertedInput();
        if (lower != null && upper != null) {
            RangeValue value = new RangeValue(lower, upper);
            if (value.getLower() <= value.getUpper()) {
                this.setConvertedInput(value);
            } else {
                ValidationError error = new ValidationError();
                error.addKey("RangeSlider.ConversionError");
                error.setVariable("lower", (Object)value.getLower());
                error.setVariable("upper", (Object)value.getUpper());
                this.error((IValidationError)error);
            }
        }
    }

    @Override
    public <W extends AbstractSlider<RangeValue>> W setRangeValidator(RangeValidator<Integer> validator) {
        this.rangeValidator = validator;
        return (W)this;
    }

    protected String getLabelPattern() {
        return "'[' + ui.values[0] + ', ' +  ui.values[1] + ']'";
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        if (this.rangeValidator != null) {
            this.lower.add(this.rangeValidator);
            this.upper.add(this.rangeValidator);
        }
    }

    @Override
    protected void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        StringBuilder statements = new StringBuilder();
        statements.append("$('#").append(this.lower.getMarkupId()).append("').val(ui.values[0]); ");
        statements.append("$('#").append(this.upper.getMarkupId()).append("').val(ui.values[1]); ");
        if (!Strings.isEmpty((CharSequence)this.labelId)) {
            statements.append("$('#").append(this.labelId).append("').text(").append(this.getLabelPattern()).append("); ");
        }
        behavior.setOption("slide", (Serializable)((Object)String.format("function(event, ui) { %s }", statements)));
        behavior.setOption("values", (Serializable)this.getModelObject());
    }

    private RangeSlider setRange(Boolean range) {
        this.options.set("range", range);
        return this;
    }

    @Override
    protected Fragment newInputFragment(String id) {
        Fragment fragment = null;
        if (this.lower == null || this.upper == null) {
            this.lower = new HiddenField("lower", (IModel)new PropertyModel(this.getModelObject(), "lower"), Integer.class);
            this.upper = new HiddenField("upper", (IModel)new PropertyModel(this.getModelObject(), "upper"), Integer.class);
            fragment = new Fragment(id, "range-fragment", (MarkupContainer)this);
            fragment.add(new Component[]{this.lower.setOutputMarkupPlaceholderTag(true)});
            fragment.add(new Component[]{this.upper.setOutputMarkupPlaceholderTag(true)});
        } else {
            fragment = super.newInputFragment(id);
        }
        return fragment;
    }

    private JQueryAbstractBehavior newLowerBehavior() {
        return new JQueryAbstractBehavior("slider-lower"){
            private static final long serialVersionUID = 1L;

            @Override
            protected String $() {
                StringBuilder statements = new StringBuilder();
                statements.append("$('#").append(RangeSlider.this.lower.getMarkupId()).append("').on('change', function() { ");
                statements.append("$('#").append(RangeSlider.this.label.getMarkupId()).append("').slider('values', 0, $(this).val()); ");
                statements.append("} );");
                return String.format("$(function() { %s });", statements);
            }
        };
    }

    private JQueryAbstractBehavior newUpperBehavior() {
        return new JQueryAbstractBehavior("slider-upper"){
            private static final long serialVersionUID = 1L;

            @Override
            protected String $() {
                StringBuilder statements = new StringBuilder();
                statements.append("$('#").append(RangeSlider.this.upper.getMarkupId()).append("').on('change', function() { ");
                statements.append("$('#").append(RangeSlider.this.label.getMarkupId()).append("').slider('values', 1, $(this).val()); ");
                statements.append("} );");
                return String.format("$(function() { %s });", statements);
            }
        };
    }
}

