/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.slider;

import com.googlecode.wicket.jquery.ui.IJQueryWidget;
import com.googlecode.wicket.jquery.ui.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.Options;
import com.googlecode.wicket.jquery.ui.form.slider.Orientation;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.validator.RangeValidator;

public abstract class AbstractSlider<T>
extends FormComponentPanel<T>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private static final String METHOD = "slider";
    protected Options options;
    protected Label label;
    protected String labelId = null;

    public AbstractSlider(String id) {
        super(id);
    }

    public AbstractSlider(String id, IModel<T> model) {
        super(id, model);
    }

    public AbstractSlider(String id, IModel<T> model, Label label) {
        super(id, model);
        label.setDefaultModel(model);
        label.setOutputMarkupId(true);
        this.setLabelId(label.getMarkupId());
    }

    protected void init() {
        this.options = new Options();
        this.label = new Label(METHOD, "");
        this.add(new Component[]{this.label});
    }

    protected abstract void convertInput();

    public abstract <W extends AbstractSlider<T>> W setRangeValidator(RangeValidator<Integer> var1);

    public AbstractSlider<T> setLabelId(String markupId) {
        this.labelId = markupId;
        return this;
    }

    protected Fragment newInputFragment(String id) {
        return new Fragment(id, "empty-fragment", (MarkupContainer)this);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.newInputFragment("model")});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, (Component)this.label)});
    }

    protected void onConfigure(JQueryBehavior behavior) {
        behavior.setOptions(this.options);
    }

    @Override
    public JQueryBehavior newWidgetBehavior(String selector) {
        return new JQueryBehavior(selector, METHOD){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                AbstractSlider.this.onConfigure(this);
            }
        };
    }

    public <W extends AbstractSlider<T>> W setMin(Integer min) {
        this.options.set("min", min);
        return (W)this;
    }

    public <W extends AbstractSlider<T>> W setMax(Integer max) {
        this.options.set("max", max);
        return (W)this;
    }

    public <W extends AbstractSlider<T>> W setStep(Integer step) {
        this.options.set("step", step);
        return (W)this;
    }

    public <W extends AbstractSlider<T>> W setOrientation(Orientation orientation) {
        this.options.set("orientation", (Serializable)((Object)orientation));
        return (W)this;
    }
}

