/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.io.IClusterable;

public class Options
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Serializable> map = new HashMap<String, Serializable>();

    public static String asString(Object value) {
        return Options.asString(value.toString());
    }

    public static String asString(String value) {
        return String.format("\"%s\"", value);
    }

    public static String asDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        return Options.asString(df.format(date));
    }

    public Options() {
    }

    public Options(String key, Serializable value) {
        this();
        this.set(key, value);
    }

    public Serializable get(String key) {
        return this.map.get(key);
    }

    public Options set(String key, Serializable value) {
        if (value != null) {
            this.map.put(key, value);
        } else {
            this.map.remove(key);
        }
        return this;
    }

    public Set<Map.Entry<String, Serializable>> entries() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        int i = 0;
        for (Map.Entry<String, Serializable> entry : this.map.entrySet()) {
            if (i++ > 0) {
                builder.append(", ");
            }
            builder.append("\"").append(entry.getKey()).append("\": ").append(entry.getValue());
        }
        return builder.append("}").toString();
    }
}

