/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.util.monitor;

import com.google.code.rees.scope.util.monitor.MonitoredContext;
import com.google.code.rees.scope.util.monitor.TimeoutListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class HashMonitoredContext<K, V, T extends MonitoredContext<K, V, T>>
extends HashMap<K, V>
implements MonitoredContext<K, V, T> {
    private static final long serialVersionUID = 5810194340880306239L;
    protected Collection<TimeoutListener<T>> timeoutListeners;
    protected long timeOfMostRecentAccess;
    protected long maxIdleTime;

    public HashMonitoredContext(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
        this.timeoutListeners = new HashSet<TimeoutListener<T>>();
        this.ping();
    }

    @Override
    public V get(Object key) {
        this.ping();
        return super.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.ping();
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.ping();
        super.putAll(m);
    }

    @Override
    public Collection<V> values() {
        this.ping();
        return super.values();
    }

    @Override
    public V remove(Object key) {
        this.ping();
        return super.remove(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.ping();
        return super.entrySet();
    }

    @Override
    public Set<K> keySet() {
        this.ping();
        return super.keySet();
    }

    @Override
    public long getRemainingTime() {
        long remainingTime = this.timeOfMostRecentAccess + this.maxIdleTime - System.currentTimeMillis();
        return remainingTime;
    }

    @Override
    public void reset() {
        this.ping();
    }

    @Override
    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public void addTimeoutListener(TimeoutListener<T> timeoutListener) {
        this.timeoutListeners.add(timeoutListener);
    }

    @Override
    public void timeout() {
        for (TimeoutListener<HashMonitoredContext> timeoutListener : this.timeoutListeners) {
            timeoutListener.onTimeout(this);
        }
        this.timeoutListeners.clear();
        this.clear();
    }

    protected void ping() {
        this.timeOfMostRecentAccess = System.currentTimeMillis();
    }
}

