/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2;

import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.context.ConversationContext;
import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import com.google.code.rees.scope.util.RequestContextUtil;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class StrutsConversationAdapter
extends ConversationAdapter {
    private static final long serialVersionUID = -907192380776385729L;
    protected ConversationContextManager conversationContextManager;
    protected ActionInvocation invocation;
    protected ActionContext actionContext;
    protected HttpServletRequest request;
    protected Map<String, String> requestContext;

    public StrutsConversationAdapter(ActionInvocation invocation, ConversationContextManager conversationContextManager) {
        this.invocation = invocation;
        this.actionContext = invocation.getInvocationContext();
        this.conversationContextManager = conversationContextManager;
    }

    @Override
    public Object getAction() {
        return this.invocation.getAction();
    }

    @Override
    public String getActionId() {
        return this.invocation.getProxy().getMethod();
    }

    @Override
    public Map<String, String> getRequestContext() {
        HttpServletRequest currentRequest;
        if (this.requestContext == null && !(currentRequest = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest")).equals(this.request)) {
            this.request = currentRequest;
            this.requestContext = RequestContextUtil.getRequestContext(currentRequest);
        }
        return this.requestContext;
    }

    @Override
    public ConversationContext beginConversation(String conversationName, long maxIdleTimeMillis) {
        return this.conversationContextManager.createContext(conversationName, maxIdleTimeMillis);
    }

    @Override
    public ConversationContext getConversationContext(String conversationName, String conversationId) {
        return this.conversationContextManager.getContext(conversationName, conversationId);
    }

    @Override
    public ConversationContext endConversation(String conversationName, String conversationId) {
        return this.conversationContextManager.remove(conversationName, conversationId);
    }
}

