/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.spring;

import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.context.ConversationContext;
import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import com.google.code.rees.scope.util.RequestContextUtil;
import com.google.code.rees.scope.util.SessionContextUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;

public class SpringConversationAdapter
extends ConversationAdapter {
    private static final long serialVersionUID = 5664922664767226366L;
    protected ConversationContextManager conversationContextManager;
    protected Map<String, Object> sessionContext;
    protected Map<String, String> requestContext;
    protected Object action;
    protected String actionId;
    protected HttpServletRequest request;

    public SpringConversationAdapter(HttpServletRequest request, HandlerMethod handler, ConversationContextManager conversationContextManager) {
        this.sessionContext = SessionContextUtil.getSessionContext(request);
        this.requestContext = RequestContextUtil.getRequestContext(request);
        this.action = handler.getBean();
        this.actionId = handler.getMethod().getName();
        this.conversationContextManager = conversationContextManager;
    }

    @Override
    public Object getAction() {
        return this.action;
    }

    @Override
    public String getActionId() {
        return this.actionId;
    }

    @Override
    public Map<String, String> getRequestContext() {
        HttpServletRequest currentRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        if (!currentRequest.equals(this.request)) {
            this.request = currentRequest;
            this.requestContext = RequestContextUtil.getRequestContext(currentRequest);
        }
        return this.requestContext;
    }

    @Override
    public ConversationContext beginConversation(String conversationName, long maxIdleTimeMillis) {
        return this.conversationContextManager.createContext(conversationName, maxIdleTimeMillis);
    }

    @Override
    public ConversationContext getConversationContext(String conversationName, String conversationId) {
        return this.conversationContextManager.getContext(conversationName, conversationId);
    }

    @Override
    public ConversationContext endConversation(String conversationName, String conversationId) {
        return this.conversationContextManager.remove(conversationName, conversationId);
    }
}

