/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.spring;

import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import com.google.code.rees.scope.conversation.context.HttpConversationContextManagerProvider;
import com.google.code.rees.scope.conversation.processing.ConversationProcessor;
import com.google.code.rees.scope.spring.SpringConversationAdapter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class ConversationInterceptor
implements HandlerInterceptor {
    protected ConversationProcessor conversationProcessor;
    protected HttpConversationContextManagerProvider conversationContextManagerProvider;

    public void setConversationManager(ConversationProcessor conversationProcessor) {
        this.conversationProcessor = conversationProcessor;
    }

    public void setConversationContextManagerProvider(HttpConversationContextManagerProvider conversationContextManagerProvider) {
        this.conversationContextManagerProvider = conversationContextManagerProvider;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
        ConversationAdapter.getAdapter().executePostProcessors();
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ConversationContextManager contextManager = this.conversationContextManagerProvider.getManager(request);
        SpringConversationAdapter adapter = new SpringConversationAdapter(request, (HandlerMethod)handler, contextManager);
        this.conversationProcessor.processConversations(adapter);
        return true;
    }
}

